﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace WlanTest {


/*!--------------------------------------------------------------------------*
  @brief        クラスに依存しない関数ポインタインタフェース
                （今のところマルチキャストはできない）

 *---------------------------------------------------------------------------*/
template<typename Arg>
class IDelegate
{
public:
    virtual ~IDelegate(){}
    virtual void operator()(Arg a) const = 0;
};

/*!--------------------------------------------------------------------------*
  @brief        クラスに依存しない関数ポインタ

 *---------------------------------------------------------------------------*/
template<typename Class, typename Arg>
class Delegate : public IDelegate<Arg>
{
public:
private:
    typedef void (Class::*Fn)(Arg);

private:
    Class* obj;
    Fn fn;

public:
    virtual void operator()(Arg a) const
    {
        (obj->*fn)(a);
    }

public:
    Delegate(Class& obj, Fn fn)
    {
        this->obj = &obj;
        this->fn = fn;
    }
};


/*!--------------------------------------------------------------------------*
  @brief        EventArgs

 *---------------------------------------------------------------------------*/
class EventArgs
{
};


/*!--------------------------------------------------------------------------*
  @brief        イベントハンドラインタフェース

 *---------------------------------------------------------------------------*/
typedef IDelegate<const EventArgs*> IEventHandler;
#define EventHandler(a) Delegate<a,const EventArgs*>
// template typedefが使えないので、こうしておく。

}
