﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs.h>
#include <nn/fs/fs_Debug.h>
#include "TextWriter.h"

using namespace std;

namespace WlanTest {


class CardWriter : public TextWriter
{
/*---------------------------------------------------------------------------
　　　　　メンバ変数
---------------------------------------------------------------------------*/
public:
protected:

    nn::os::Mutex m_Cs;
    nn::fs::FileHandle m_Handler;
    uint32_t m_BufferedSize;
    string m_DirPath;
    string m_FileName;
    bool m_IsInitialized;

private:

/*---------------------------------------------------------------------------
　　　　　メンバメソッド
---------------------------------------------------------------------------*/
public:

    //! 文字列を書き込みます
    virtual bool Write(const string& str);
    virtual bool Flush();

    // sd: 直下にディレクトリを作る場合(1階層)は dirName を指定する
    virtual bool Initialize(const string& dirName = "", const string& filePrefix = "");
    virtual void Finalize();

protected:

    virtual bool WriteCore(const char* str, const int64_t size);

private:


/*---------------------------------------------------------------------------
　　　　　コンストラクタ類
---------------------------------------------------------------------------*/
public:

    CardWriter();
    virtual ~CardWriter();

private:

};


} // WlanTest
