﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/wlan/wlan_Types.h>
#include "BaseScene.h"

BaseScene::BaseScene(ISceneChanger* pChanger) NN_NOEXCEPT
{
    m_SceneChanger = pChanger;
}

void BaseScene::Draw(GraphicTools* pTools) NN_NOEXCEPT
{
    NN_UNUSED(pTools);
}

int BaseScene::ConvertChannelToId(uint16_t channel)
{
    int id = 0;
    if( channel <= nn::wlan::WirelessChannel_13ch )
    {
        id = channel - 1;
    }
    else if( channel == nn::wlan::WirelessChannel_36ch )
    {
        id = 13;
    }
    else if( channel == nn::wlan::WirelessChannel_40ch )
    {
        id = 14;
    }
    else if( channel == nn::wlan::WirelessChannel_44ch )
    {
        id = 15;
    }
    else if( channel == nn::wlan::WirelessChannel_48ch )
    {
        id = 16;
    }
    else if( channel == nn::wlan::WirelessChannel_52ch )
    {
        id = 17;
    }
    else if( channel == nn::wlan::WirelessChannel_56ch )
    {
        id = 18;
    }
    else if( channel == nn::wlan::WirelessChannel_60ch )
    {
        id = 19;
    }
    else if( channel == nn::wlan::WirelessChannel_64ch )
    {
        id = 20;
    }
    else if( channel == nn::wlan::WirelessChannel_100ch )
    {
        id = 21;
    }
    else if( channel == nn::wlan::WirelessChannel_104ch )
    {
        id = 22;
    }
    else if( channel == nn::wlan::WirelessChannel_108ch )
    {
        id = 23;
    }
    else if( channel == nn::wlan::WirelessChannel_112ch )
    {
        id = 24;
    }
    else if( channel == nn::wlan::WirelessChannel_116ch )
    {
        id = 25;
    }
    else if( channel == nn::wlan::WirelessChannel_120ch )
    {
        id = 26;
    }
    else if( channel == nn::wlan::WirelessChannel_124ch )
    {
        id = 27;
    }
    else if( channel == nn::wlan::WirelessChannel_128ch )
    {
        id = 28;
    }
    else if( channel == nn::wlan::WirelessChannel_132ch )
    {
        id = 29;
    }
    else if( channel == nn::wlan::WirelessChannel_136ch )
    {
        id = 30;
    }
    else if( channel == nn::wlan::WirelessChannel_140ch )
    {
        id = 31;
    }
    else if( channel == nn::wlan::WirelessChannel_144ch )
    {
        id = 32;
    }
    else if( channel == nn::wlan::WirelessChannel_149ch )
    {
        id = 33;
    }
    else if( channel == nn::wlan::WirelessChannel_153ch )
    {
        id = 34;
    }
    else if( channel == nn::wlan::WirelessChannel_157ch )
    {
        id = 35;
    }
    else if( channel == nn::wlan::WirelessChannel_161ch )
    {
        id = 36;
    }
    else if( channel == nn::wlan::WirelessChannel_165ch )
    {
        id = 37;
    }
    else
    {
        id = 0;
    }

    return id;
} //NOLINT(impl/function_size)
