﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../common.h"

void TestLocalMasterAndClient()
{
    nn::Result      result;

    nn::wlan::InitializeLocalManager();

    /////// MASTER ///////
    nn::wlan::Local::OpenMasterMode();
    nn::wlan::MasterBssParameters param;
    param.channel = 11;
    param.autoKeepAlive = false; // inactivePeriod = 0で同等のことが出来るので使用しない。（一応値は入れておく）
    param.basicRates = nn::wlan::RateSetLegacy_11gMask;
    param.supportedRates = nn::wlan::RateSetLegacy_11gMask;
    param.beaconInterval = 100;
    param.hiddenSsid = false;
    param.inactivePeriod = 10; // 10sec
    param.security.privacyMode = nn::wlan::SecurityMode_StaticAes;
    param.security.groupPrivacyMode = nn::wlan::SecurityMode_StaticAes;
    std::memcpy(&param.security.key[0], &WlanTest::staticAesKey[0], sizeof(WlanTest::staticAesKey));
    param.ssid.Set(WlanTest::localMasterSsid);
    nn::wlan::Local::CreateBss(param);
    NN_LOG("BSS starts on 11ch\n");

    // 5秒待ってからBSS止める
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5000));

    nn::wlan::Local::DestroyBss();  // 内部で全体にDeauthを投げているので、終了前に切断を明示的に行う必要はない。
    NN_LOG("BSS ends on 11ch\n");

    nn::wlan::Local::CloseMasterMode();

    /////// CLIENT ///////
    nn::os::SystemEventType connectionEvent;
    nn::wlan::Local::OpenClientMode();
    nn::wlan::Local::GetConnectionEvent(&connectionEvent);

    nn::wlan::MacAddress macAddr;
    nn::wlan::Local::GetMacAddress(&macAddr);
    char macStr[nn::wlan::MacAddress::MacStringSize];
    NN_LOG("mac addr : %s\n", macAddr.GetString(macStr));

    // 相手先のセキュリティ情報入力
    nn::wlan::Security security = {
            nn::wlan::SecurityMode_StaticAes,
            nn::wlan::SecurityMode_StaticAes,
            0,
            "",
    };
    std::memcpy(&security.key[0], &WlanTest::staticAesKey[0], 16);

    nn::wlan::Ssid peerSsid(WlanTest::localMasterSsid);
    nn::wlan::Local::Connect(peerSsid,
            nn::wlan::MacAddress::CreateBroadcastMacAddress(),
            -1,
            security,
            false,
            nn::wlan::BeaconIndication_Disable);

    nn::os::WaitSystemEvent(&connectionEvent);

    nn::wlan::ConnectionStatus connectionStatus;
    nn::wlan::Local::GetConnectionStatus(&connectionStatus);

    if( connectionStatus.state == nn::wlan::ConnectionState_Connected )
    {
        NN_LOG("WlanTest: CONNECTED!!!\n");
        nn::wlan::Local::Disconnect(nn::wlan::LocalCommunicationMode_ClientSpectator);
    }

    nn::wlan::Local::CloseClientMode();
    nn::wlan::FinalizeLocalManager();

} //NOLINT(impl/function_size)

extern "C" void nnMain()
{
    NN_LOG("\n\n Start WlanTest LocalMaster\n\n");
    WlanTest::SystemInitialize();

    for( int i = 1; i < 11; i++ )
    {
        NN_LOG("[%d]Loop\n", i);
        TestLocalMasterAndClient();
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(5));
    }
    WlanTest::SystemFinalize();
}

