﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BaseScene.h"
#include "ISceneChanger.h"
#include "WirelessData.h"

class SceneManager : public ISceneChanger, Task, WirelessData
{

private:
    BaseScene* m_scene;
    eScene m_nextScene;
    eScene m_currScene;
    eScene m_prevScene;
    ApplicationHeap* m_pApplicationHeap;

    char m_password[64];

    bool m_isExit;

public:
    explicit SceneManager(ApplicationHeap* pApplicationHeap) NN_NOEXCEPT;
    void Initialize()  NN_NOEXCEPT override;
    void Finalize() NN_NOEXCEPT override;
    void Update() NN_NOEXCEPT override;
    void Draw(
            GraphicsSystem* pGraphicsSystem,
            FontSystem* pFontSystem
            ) NN_NOEXCEPT override;
    bool IsExit() NN_NOEXCEPT;

    // 引数 nextScene にシーンを変更する
    void ChangeScene(eScene NextScene) NN_NOEXCEPT override;
    eScene GetPrevScene() NN_NOEXCEPT override;

    // 無線通信に関するデータ共有用関数
    void SetScanResult(char* pData, size_t size) NN_NOEXCEPT override;
    char* GetScanResult() NN_NOEXCEPT override;
    void SetConnectionParam(nn::wlan::Ssid ssid, int16_t channel,
            nn::wlan::Security security, char* pw) NN_NOEXCEPT override;
    void GetConnectionParam(nn::wlan::Ssid* ssid, int16_t* channel,
            nn::wlan::Security* security, char* pw) NN_NOEXCEPT override;
    void SetOwnIp(nn::wlan::WlanIpv4Address ip) NN_NOEXCEPT override;
    void GetOwnIp(nn::wlan::WlanIpv4Address* pIp) NN_NOEXCEPT override;
    void SetMasterParam(nn::wlan::MasterBssParameters bssParam,
            PeriodicActionFrameParam afParam) override;
    void GetMasterParam(nn::wlan::MasterBssParameters* bssParam,
            PeriodicActionFrameParam* afParam) override;
};
