﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>


class Npad
{
public:
    enum Button
    {
        START = 0,
        SELECT,
        A,
        B,
        X,
        Y,
        L,
        R,
        ZL,
        ZR,
        LEFT,
        UP,
        RIGHT,
        DOWN,
        SL,       // stick left emulation
        SL_LEFT,
        SL_UP,
        SL_RIGHT,
        SL_DOWN,
        SR,      // stick right emulation
        SR_LEFT,
        SR_UP,
        SR_RIGHT,
        SR_DOWN,
        MINUS,
        PLUS
    };

    struct PadState
    {
        nn::hid::NpadButtonSet trigger;
        nn::hid::NpadButtonSet hold;
        nn::hid::NpadButtonSet release;
    };

    nn::TimeSpan m_HoldDetectionDelay;
    nn::TimeSpan m_HoldDetectionInterval;

protected:
    static const int NpadIdCountMax = 5;
    static const nn::hid::NpadIdType m_NpadIds[NpadIdCountMax];

    PadState m_CurrentState;
    nn::TimeSpan m_PressTime;
    nn::TimeSpan m_PreviousDetectionTime;

private:
    static bool m_IsEnabled;
    static bool m_IsIrConfigurationEnabled;

public:
    virtual ~Npad();

    static Npad& GetInstance();
    static void EnablePad();
    static void DisablePad();
    static void Finalize();

    void UpdatePadState();

    bool IsTrigger(Button button);
    bool IsHold(Button button);
    bool IsRelease(Button button);
    void Clear();

    void DisconnectNpad(const nn::hid::NpadIdType& id);
    void DisconnectAllNpads();

private:
    int ToNpadButton(Button button);

protected:
    Npad();

};
