﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

typedef enum {
    eScene_Title,
    eScene_MasterSetting,
    eScene_MasterRunning,
    eScene_Scanning,
    eScene_ScanResult,
    eScene_ConnectionParam,
    eScene_Connecting,
    eScene_ConnectFailure,
    eScene_Connected,
    eScene_DirectInput,
    eScene_Preset,
    eScene_Exit,
    eScene_None,
} eScene;

//シーンを変更するためのインターフェイスクラス
class ISceneChanger
{
public:
    virtual ~ISceneChanger() NN_NOEXCEPT;
    virtual void ChangeScene(eScene NextScene) NN_NOEXCEPT = 0;//指定シーンに変更する
    virtual eScene GetPrevScene() NN_NOEXCEPT = 0; // 直前のシーンが何であったか取得する
};
