﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>

#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_ApiCommunicationControlForTest.h>

#include <nn/wlan/wlan_InfraApi.h>

extern "C" void nnMain()
{
    NN_LOG("\n\n Start InitializeWlanOnSkipBoot \n\n");

    // wlan単独で動けるようにnifmの動きを止める----------------//
    const bool isEnabled = true;
    nn::settings::fwdbg::SetSettingsItemValue("nifm", "is_communication_control_enabled_for_test", &isEnabled, sizeof(isEnabled));

    nn::nifm::Initialize();
    nn::nifm::SetWirelessCommunicationEnabledForTest(false);
    // nifmのwlan利用停止を確実に待つために1秒ほどwaitを入れておく
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));
    // --------------------------------------------------------//

    nn::Result result;

    // wlanライブラリの初期化
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::wlan::InitializeInfraManager());

    // wlanを有効化する
    result = nn::wlan::Infra::InitializeWlanOnSkipBoot();
    if( result.IsFailure() == true )
    {
        // skip_bootがtrueになっていない。終了。
        NN_LOG("wlan skip boot is not true.\nEnd.\n");
        return;
    }

    // wlanが有効化されたので、インフラモードをオープンしてみる。
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::wlan::Infra::OpenMode());

    // 無線FWのバージョンを取得（無線ドライバーが機能しているかの確認）
    char str[256];
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::wlan::Infra::GetFwVersion(str, sizeof(str)));
    NN_LOG("FW ver:\n%s\n", str);

    // インフラモードの終了
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::wlan::Infra::CloseMode());
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::wlan::FinalizeInfraManager());

    NN_LOG("\n\n [SUCCESS]End InitializeWlanOnSkipBoot \n\n");
}

