﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Network.h"


void cleanup(void);

extern "C"
{

namespace
{

const int  MemoryPoolSize = 10 * 1024 * 1024;
uint8_t    mempool[MemoryPoolSize];
size_t     mempoolSize = MemoryPoolSize;

}

int testMain(int argc, char **argv);
int sig_dispatcher(int type);

extern int __gnu_getopt_initialized;

}


namespace ApConnectivityTest
{

NN_OS_ALIGNAS_THREAD_STACK uint8_t Network::g_IperfThreadStackMemory[8192];


// コンストラクタ
Network::IperfStartTask::IperfStartTask() :
        Network::Task(Network::TaskType_StartIperf)
{
}


// デストラクタ
Network::IperfStartTask::~IperfStartTask()
{
}


// 実行
void Network::IperfStartTask::Run()
{
    // iperf スレッドを初期化
    void(Network::*pTheadFunc)() = &Network::IperfWorkerThread;
    nn::os::CreateThread(&Network::GetInstance().m_IperfThread,
            *reinterpret_cast<nn::os::ThreadFunction*>(&pTheadFunc), &Network::GetInstance(),
            g_IperfThreadStackMemory, sizeof(g_IperfThreadStackMemory),
            nn::os::DefaultThreadPriority);

    nn::os::StartThread(&Network::GetInstance().m_IperfThread);
}


// コンストラクタ
Network::IperfStopTask::IperfStopTask() :
        Network::Task(Network::TaskType_StopIperf)
{
}


// デストラクタ
Network::IperfStopTask::~IperfStopTask()
{
}


// 実行
void Network::IperfStopTask::Run()
{
    if (__gnu_getopt_initialized)
    {
        sig_dispatcher(0);
        cleanup();
    }
}


// コンストラクタ
Network::IperfExitCallbackTask::IperfExitCallbackTask() :
    Network::Task(Network::TaskType_IperfExitCallback)
{
}


// デストラクタ
Network::IperfExitCallbackTask::~IperfExitCallbackTask()
{
}


// 実行
void Network::IperfExitCallbackTask::Run()
{
    auto& network = Network::GetInstance();

    nn::os::DestroyThread(&network.m_IperfThread);

    __gnu_getopt_initialized = 0;

    network.m_IperfExitCallback();
}


// Iperf スレッド
void Network::IperfWorkerThread()
{
    m_RunningIperf = true;

    static const std::string argv0("iperf ");

    std::vector<char> commandline(argv0.size() + m_IperfCommandline.size() + 1);
    std::vector<char*> argv;

    argv0.copy(commandline.data(), argv0.size());
    m_IperfCommandline.copy(commandline.data() + argv0.size(), m_IperfCommandline.size());
    commandline.back() = '\0';

    bool stateWhitespace = true;
    for (auto pStr = commandline.data(); *pStr; ++pStr)
    {
        if ((*pStr == ' ') == stateWhitespace)
        {
            continue;
        }

        stateWhitespace = !stateWhitespace;
        if (stateWhitespace)
        {
            *pStr = '\0';
        }
        else
        {
            argv.push_back(pStr);
        }
    }

    __gnu_getopt_initialized = 0;
    testMain(argv.size(), argv.data());

    m_RunningIperf = false;

    // コマンド発行
    m_CommandQueue.Push(std::shared_ptr<Task>(new IperfExitCallbackTask()));
}


}
