﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

namespace gfxutil
{

class MemoryPoolAllocator;

//! @brief      フォントを表示できるようにします
class FontRenderer
{
public:
    //! @brief  必要なメモリ量を取得します
    size_t GetRequiredMemorySize(nn::gfx::Device* pDevice) NN_NOEXCEPT;
    //! @brief  初期化します
    void Initialize(nn::gfx::Device* pDevice, void* pMemory, size_t memorySize, int width, int height, nn::gfx::DescriptorPool* pSamplerDescriptorPool, int samplerDescriptorPoolSlot, nn::gfx::DescriptorPool* pTextureDescriptorPool, int textureDescriptorPoolSlot) NN_NOEXCEPT;
    //! @brief  終了処理をします
    void Finalize() NN_NOEXCEPT;
    //! @brief  文字列の描画コマンドを発行します
    void FlushCommand(nn::gfx::CommandBuffer* pCommandBuffer) NN_NOEXCEPT;
    //! @brief  文字列を描画します
    void Print(const char* string) NN_NOEXCEPT;

    //! @brief  文字の描画位置を設定します
    void SetPosition(float positionX, float positionY) NN_NOEXCEPT;
    //! @brief  文字の色を設定します
    void SetColor(const nn::util::Unorm8x4& color) NN_NOEXCEPT;
    //! @brief  文字のスケールを設定します
    void SetScale(float scaleX, float scaleY) NN_NOEXCEPT;

    //! @brief  文字を描画したときの幅を計算します
    float CalculateWidth(const char* str) NN_NOEXCEPT;
    //! @brief  文字を描画したときの高さを計算します
    float CalculateHeight(const char* str) NN_NOEXCEPT;

    void EnableFixedFont(bool enable);
    void SetFixedFontWidth(float width);
    float GetFixedFontWidth();
    float GetFontHeight();

private:
    nn::gfx::util::DebugFontTextWriter m_DebugFont;
};


}
