﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/util/util_MathTypes.h>


extern const nn::util::Float2 GetFloat2(float x, float y) NN_NOEXCEPT;
extern const nn::util::Uint8x4 GetUint8x4(uint8_t x, uint8_t y, uint8_t z, uint8_t w) NN_NOEXCEPT;
extern const nn::util::Unorm8x4 GetUnorm8x4(uint8_t x, uint8_t y, uint8_t z, uint8_t w) NN_NOEXCEPT;

struct Rect
{
    float x;
    float y;
    float width;
    float height;
};
