﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Utils.h"
#include "gfxutil/GfxContext.h"
#include <nn/diag/diag_LogObserver.h>
#include <nn/hid/hid_DebugPad.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_MutexTypes.h>
#include <cstdio>
#include <functional>
#include <list>
#include <memory>
#include <string>
#include <vector>


namespace ApConnectivityTest {
namespace UI {

class ConsoleView
{
public:
    ConsoleView(float left, float Top, float width, float height);
    virtual ~ConsoleView();

    void Initialize();
    void Finalize();

    void Clear();
    void Draw(const std::vector<Rect>& excludeRegions);

    virtual void ConsoleWrite(const std::string& str);

    void SetLeft(float left);
    float GetLeft() const;

    void SetTop(float top);
    float GetTop() const;

    void SetWidth(float width);
    float GetWidth() const;

    void SetHeight(float height);
    float GetHeight() const;

    bool GetUpdated() const;

private:
    float m_Left;
    float m_Top;
    float m_Width;
    float m_Height;

    size_t m_ScreenWidthCharCount;
    size_t m_ScreenHeightCharCount;

    bool m_Updated;

    std::list<std::string> m_Lines;

    nn::os::Mutex m_WriteMutex;

    nn::diag::LogObserverHolder g_LogObserverHolder;
};

}
}
