﻿var KEY_CODE_SPACE = 32;

var forbidsControl = true;
var invalidatesFocusSe = true;
var touchIdentifier = null;
var lastSelectedButton = null;

var returnToGameBtn = document.querySelector('button[data-func="return-to-game"]')

var returnToGame = function() {
  if (forbidsControl) {
    return;
  }
  forbidsControl = true;
  window.sound.playWithSuspend('back', function() {
    location.href = 'http://localhost/close';
    forbidsControl = false;
  });
};

var selectBalloonBtn = function(btn) {
  if (forbidsControl) {
    return;
  }
  lastSelectedButton = btn;
  forbidsControl = true;

  btn.classList.add('hover');
  if (btn.matches('[data-href]')) {
    window.sound.playWithSuspend('decide', function() {
      location.href = btn.dataset.href;
    });
  }
  else if (btn.matches('[data-callback-id]')) {
    window.sound.playWithSuspend('exit', function() {
      location.href = 'http://localhost/?id=' + btn.dataset.callbackId;
    });
  }
};

var isExcessiveTouch = function(event) {
  return event.targetTouches[0].identifier !== event.touches[0].identifier;
};

var findTargetTouch = function(event) {
  var i, changedTouch;
  for (i = 0; i < event.changedTouches.length; ++i) {
    changedTouch = event.changedTouches[i];
    if (changedTouch.target === event.currentTarget &&
        changedTouch.identifier === touchIdentifier) {
      return changedTouch;
    }
  }
  return null;
}

var update = function() {
  var pad;
  if (navigator.getGamepads && navigator.getGamepads()[0]) {
    pad = navigator.getGamepads()[0];
    if (pad.buttons[8].pressed || pad.buttons[9].pressed) {
      returnToGame();
    }
  }
  requestAnimationFrame(update);
};

var resume = function() {
  forbidsControl = false;
  lastSelectedButton.classList.remove('hover');
  window.sound.resume();
};

Array.prototype.forEach.call(document.querySelectorAll('.balloon button'), function(btn) {

  btn.addEventListener('keydown', function(event) {
    var target = event.currentTarget;
    if (forbidsControl) {
      event.preventDefault();
      return;
    }
    if (event.keyCode !== KEY_CODE_SPACE) {
      return;
    }
    selectBalloonBtn(target);
  });

  btn.addEventListener('focus', function(event) {
    var target = event.currentTarget;
    target.classList.add('focus');
    if (!invalidatesFocusSe) {
      window.sound.play('focus');
    }
    invalidatesFocusSe = false;
  });

  btn.addEventListener('blur', function(event) {
    if (!event.relatedTarget) {
      invalidatesFocusSe = true;
      event.currentTarget.focus();
    }
    else {
      event.currentTarget.classList.remove('focus');
    }
  });

  btn.addEventListener('touchstart', function(event) {
    var target = event.currentTarget;
    event.preventDefault();
    if (forbidsControl) {
      return;
    }
    if (isExcessiveTouch(event)) {
      return;
    }
    touchIdentifier = event.targetTouches[0].identifier;
    if (target.classList.contains('hover')) {
      return;
    }
    if (document.activeElement === target) {
      window.sound.play('focus');
    }
    target.focus();
    target.classList.add('hover');
  });

  btn.addEventListener('touchmove', function(event) {
    var target = event.currentTarget, targetTouch, coord, rect;
    event.preventDefault();
    if (forbidsControl) {
      return;
    }
    var targetTouch = findTargetTouch(event);
    if (!targetTouch) {
      return;
    }
    coord = {
      x: targetTouch.clientX,
      y: targetTouch.clientY
    };
    rect = target.getBoundingClientRect();
    if (rect.left <= coord.x && coord.x <= rect.right &&
      rect.top <= coord.y && coord.y <= rect.bottom) {
      target.classList.add('hover');
    }
    else {
      target.classList.remove('hover');
    }
  });

  btn.addEventListener('touchend', function(event) {
    var target = event.currentTarget, targetTouch, coord, rect;
    event.preventDefault();
    if (forbidsControl) {
      return;
    }
    var targetTouch = findTargetTouch(event);
    if (!targetTouch) {
      return;
    }
    touchIdentifier = null;
    target.classList.remove('hover');
    coord = {
      x: targetTouch.clientX,
      y: targetTouch.clientY
    };
    rect = target.getBoundingClientRect();
    if (rect.left <= coord.x && coord.x <= rect.right &&
      rect.top <= coord.y && coord.y <= rect.bottom) {
      selectBalloonBtn(target);
    }
  });

  btn.addEventListener('touchcancel', function(event) {
    var target = event.currentTarget;
    event.currentTarget.classList.remove('hover');
  });

});

returnToGameBtn.addEventListener('touchstart', function(event) {
  var target = event.currentTarget;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  if (isExcessiveTouch(event)) {
    return;
  }
  touchIdentifier = event.targetTouches[0].identifier;
  if (target.classList.contains('hover')) {
    return;
  }
  window.sound.play('focus');
  target.classList.add('hover');
});

returnToGameBtn.addEventListener('touchmove', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
    rect.top <= coord.y && coord.y <= rect.bottom) {
    target.classList.add('hover');
  }
  else {
    target.classList.remove('hover');
  }
});

returnToGameBtn.addEventListener('touchend', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  touchIdentifier = null;
  target.classList.remove('hover');
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
    rect.top <= coord.y && coord.y <= rect.bottom) {
    returnToGame();
  }
});

returnToGameBtn.addEventListener('touchcancel', function(event) {
  var target = event.currentTarget;
  target.classList.remove('hover');
});

if (window.nx && window.nx.footer && window.nx.footer.setAssign) {
  window.nx.footer.setAssign('B', null, returnToGame, {
    se: ''
  });
}

if (window.nx && window.nx.footer && window.nx.footer.unsetAssign) {
  window.nx.footer.unsetAssign('X');
}

window.sound.load({'back': 'snd/SeBack.mp4', 'decide': 'snd/SeDecide.mp4', 'exit': 'snd/SeExit.mp4', 'focus': 'snd/SeFocus.mp4'}, function() {
  forbidsControl = false;
});

window.onpageshow = function(event) {
  if (event.persisted) {
    resume();
  }
};

update();
