﻿var KEY_CODE_SPACE = 32;

var forbidsControl = false;
var invalidatesFocusSe = true;
var touchIdentifier = null;

var selectBtn = function(btn) {
  if (forbidsControl) {
    return;
  }
  forbidsControl = true;

  btn.classList.add('selected');
  btn.blur();

  if (window.nx && window.nx.playSystemSe) {
    window.nx.playSystemSe('SeWebButtonDecide');
  }

  setTimeout(function() {
    var destSection;
    if (btn.classList.contains('selected')) {
      if (btn.dataset.dest) {
        destSection = document.querySelector(btn.dataset.dest);
        btn.classList.remove('selected');
        location.href = btn.dataset.dest;
      }
      else if (btn.dataset.href) {
        location.href = btn.dataset.href;
      }
    }
    forbidsControl = false;
  }, 250);
};

var back = function() {
  var hash = location.hash;

  if (forbidsControl) {
    return;
  }

  if (window.nx && window.nx.playSystemSe) {
    window.nx.playSystemSe('SeFooterDecideBack');
  }

  if (hash === '#index') {
    location.href = 'http://localhost/close';
  }
  else {
    location.replace('#index');
    document.querySelector('[data-dest="' + hash + '"]').focus();
  }
};

var isExcessiveTouch = function(event) {
  return event.targetTouches[0].identifier !== event.touches[0].identifier;
};

var findTargetTouch = function(event) {
  var i, changedTouch;
  for (i = 0; i < event.changedTouches.length; ++i) {
    changedTouch = event.changedTouches[i];
    if (changedTouch.target === event.currentTarget &&
        changedTouch.identifier === touchIdentifier) {
      return changedTouch;
    }
  }
  return null;
}

if (location.hash === '') {
  location.replace('#index');
}

Array.prototype.forEach.call(document.querySelectorAll('.btn'), function(item) {

  item.addEventListener('keydown', function(event) {
    var target = event.currentTarget;
    if (event.keyCode !== KEY_CODE_SPACE) {
      return;
    }
    selectBtn(target);
  });

  item.addEventListener('focus', function(event) {
    var target = event.currentTarget;
    target.classList.add('focus');
    if (!invalidatesFocusSe && window.nx && window.nx.playSystemSe) {
      window.nx.playSystemSe('SeWebNaviFocus');
    }
    invalidatesFocusSe = false;
  });

  item.addEventListener('blur', function(event) {
    var target = event.currentTarget;
    if (forbidsControl) {
      return;
    }
    if (!event.relatedTarget) {
      invalidatesFocusSe = true;
      target.focus();
    }
    else {
      target.classList.remove('focus');
    }
  });

  item.addEventListener('touchstart', function(event) {
    var target = event.currentTarget;
    event.preventDefault();
    if (forbidsControl) {
      return;
    }
    if (isExcessiveTouch(event)) {
      return;
    }
    touchIdentifier = event.targetTouches[0].identifier;
    if (target.classList.contains('hover')) {
      return;
    }
    if (document.activeElement === target && window.nx && window.nx.playSystemSe) {
      window.nx.playSystemSe('SeWebNaviFocus');
    }
    target.focus();
    target.classList.add('hover');
  });

  item.addEventListener('touchmove', function(event) {
    var target = event.currentTarget, targetTouch, coord, rect;
    event.preventDefault();
    if (forbidsControl) {
      return;
    }
    var targetTouch = findTargetTouch(event);
    if (!targetTouch) {
      return;
    }
    coord = {
      x: targetTouch.clientX,
      y: targetTouch.clientY
    };
    rect = target.getBoundingClientRect();
    if (rect.left <= coord.x && coord.x <= rect.right &&
      rect.top <= coord.y && coord.y <= rect.bottom) {
      target.classList.add('hover');
    }
    else {
      target.classList.remove('hover');
    }
  });

  item.addEventListener('touchend', function(event) {
    var target = event.currentTarget, targetTouch, coord, rect;
    event.preventDefault();
    if (forbidsControl) {
      return;
    }
    var targetTouch = findTargetTouch(event);
    if (!targetTouch) {
      return;
    }
    touchIdentifier = null;
    target.classList.remove('hover');
    coord = {
      x: targetTouch.clientX,
      y: targetTouch.clientY
    };
    rect = target.getBoundingClientRect();
    if (rect.left <= coord.x && coord.x <= rect.right &&
      rect.top <= coord.y && coord.y <= rect.bottom) {
      selectBtn(target);
    }
  });

  item.addEventListener('touchcancel', function() {
    var target = event.currentTarget;
    target.classList.remove('hover');
  });

});

document.querySelector('#back').addEventListener('touchstart', function(event) {
  var target = event.currentTarget;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  if (isExcessiveTouch(event)) {
    return;
  }
  touchIdentifier = event.targetTouches[0].identifier;
  if (target.classList.contains('hover')) {
    return;
  }
  if (window.nx && window.nx.playSystemSe) {
    window.nx.playSystemSe('SeWebNaviFocus');
  }
  target.classList.add('hover');
});

document.querySelector('#back').addEventListener('touchmove', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
    rect.top <= coord.y && coord.y <= rect.bottom) {
    target.classList.add('hover');
  }
  else {
    target.classList.remove('hover');
  }
});

document.querySelector('#back').addEventListener('touchend', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  touchIdentifier = null;
  target.classList.remove('hover');
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
    rect.top <= coord.y && coord.y <= rect.bottom) {
    back();
  }
});

document.querySelector('#back').addEventListener('touchcancel', function(event) {
  var target = event.currentTarget;
  target.classList.remove('hover');
});

document.addEventListener('keydown', function(event) {
  if (forbidsControl) {
    event.preventDefault();
  }
});

if (window.nx && window.nx.footer && window.nx.footer.setAssign) {
  window.nx.footer.setAssign('B', null, back, {
    se: ''
  });
}

if (window.nx && window.nx.footer && window.nx.footer.unsetAssign) {
  window.nx.footer.unsetAssign('X');
}
