﻿/*--------------------------------------------------------------------------------*
Copyright (C)Nintendo All rights reserved.

These coded instructions, statements, and computer programs contain proprietary
information of Nintendo and/or its licensed developers and are protected by
national and international copyright laws. They may not be disclosed to third
parties or copied or duplicated in any form, in whole or in part, without the
prior written consent of Nintendo.

The content herein is highly confidential and should be handled accordingly.
*--------------------------------------------------------------------------------*/
#if VERTEX_SHADER
    #define VARYING_QUALIFIER out
    #define VARYING_INSTANCE Out
#endif

#if PIXEL_SHADER
    #define VARYING_QUALIFIER in
    #define VARYING_INSTANCE In
#endif

VARYING_QUALIFIER Varying
{
    vec2 texCoord;
} VARYING_INSTANCE;

/// ================================================================
/// 頂点シェーダーの実装
/// ================================================================
#if VERTEX_SHADER
out gl_PerVertex
{
    vec4 gl_Position;
};

layout( location = 0 ) in vec3 i_Position;
layout( location = 1 ) in vec2 i_TexCoord;

int count = 0;

void main()
{
    gl_Position = vec4(i_Position,1.0f);
    Out.texCoord = i_TexCoord.xy;
}

#endif

/// ================================================================
/// ピクセルシェーダーの実装
/// ================================================================
#if PIXEL_SHADER

layout( location = 0 ) out vec4 o_Color;

#if DRAW_TEXTURE
uniform sampler2D s_Tex;
#else
layout( std140 ) uniform u_Constant
{
    vec4 color;
};
#endif

void main()
{
#if DRAW_TEXTURE
    vec4 albedo = texture(s_Tex,In.texCoord);
#else
    vec4 albedo = color;
#endif

    if(albedo.a == 0.0f)
    {
        discard;
    }
    o_Color = albedo;
}

#endif
