#version 400
#extension GL_ARB_separate_shader_objects : enable
#extension GL_ARB_shading_language_420pack : enable

layout (location = 0) in vec4 pos;
layout (location = 1) in vec4 inColor;
layout (location = 2) in vec2 inTexcoord;
layout (location = 0) out vec4 outColor;
layout (location = 1) out vec2 outTexcoord;

out gl_PerVertex { 
    vec4 gl_Position;
};

void main() {
   outColor = inColor;
   outTexcoord = inTexcoord;
   gl_Position = pos;

   // GL->VK conventions
   gl_Position.y = -gl_Position.y;
   gl_Position.z = (gl_Position.z + gl_Position.w) / 2.0;
}


