﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/vi/vi_RgbRange.h>
#include <nn/vi/vi_StereoMode.h>
#include <nn/vi/vi_DisplayModeInfo.h>
#include <nn/vi/vi_CmuMode.h>
#include <nn/settings/system/settings_Tv.h>

const char* ToString(nn::vi::RgbRange range) NN_NOEXCEPT;
const char* ToString(nn::vi::StereoMode mode) NN_NOEXCEPT;
const char* ToString(nn::vi::CmuMode mode) NN_NOEXCEPT;

nn::settings::system::CmuMode ToSettings(nn::vi::CmuMode) NN_NOEXCEPT;

void PrintMode(const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT;
