﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include "Utility.h"

const char* ToString(nn::vi::RgbRange range) NN_NOEXCEPT
{
#define CASE(x) case nn::vi::x: return #x

    switch (range)
    {
        CASE(RgbRange_Limited);
        CASE(RgbRange_Full);
    default:
        //NN_UNEXPECTED_DEFAULT;
        return "";
    }

#undef CASE
}

const char* ToString(nn::vi::DisplayModeInfo::StereoModeType mode) NN_NOEXCEPT
{
#define CASE(x) case nn::vi::x: return #x

    switch (mode)
    {
        CASE(StereoMode_None);
        CASE(StereoMode_FramePacking);
        CASE(StereoMode_SideBySide);
        CASE(StereoMode_TopAndBottom);
    default:
        NN_UNEXPECTED_DEFAULT;
    }

#undef CASE
}

const char* ToString(nn::vi::CmuMode mode) NN_NOEXCEPT
{
#define CASE(x) case nn::vi::x: return #x

    switch (mode)
    {
        CASE(CmuMode_Disabled);
        CASE(CmuMode_Default);
        CASE(CmuMode_InvertColor);
        CASE(CmuMode_HighContrast);
        CASE(CmuMode_Grayscale);
    default:
        NN_UNEXPECTED_DEFAULT;
    }

#undef CASE
}

nn::settings::system::CmuMode ToSettings(nn::vi::CmuMode mode) NN_NOEXCEPT
{
    switch (mode)
    {
    case nn::vi::CmuMode_Disabled:
        NN_FALL_THROUGH;
    case nn::vi::CmuMode_Default:
        return nn::settings::system::CmuMode_None;
    case nn::vi::CmuMode_InvertColor:
        return nn::settings::system::CmuMode_ColorInvert;
    case nn::vi::CmuMode_HighContrast:
        return nn::settings::system::CmuMode_HighContrast;
    case nn::vi::CmuMode_Grayscale:
        return nn::settings::system::CmuMode_GrayScale;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

void PrintMode(const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT
{
    NN_LOG("%dx%d, %.2f Hz, %s", mode.width,
                                 mode.height,
                                 mode.refreshRate,
                                 ToString(mode.mode));
}
