﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/vi/vi_Types.h>
#include "IMenuItem.h"

class UnderscanMenuItem : public IMenuItem
{
public:
    UnderscanMenuItem(nn::vi::Display* pDisplay, int underscan) NN_NOEXCEPT;

    virtual void Render() const NN_NOEXCEPT NN_OVERRIDE;
    virtual void Select() NN_NOEXCEPT NN_OVERRIDE;
private:
    int m_Underscan;
    nn::vi::Display* m_pDisplay;
};
