﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include "RgbMenuItem.h"
#include "Utility.h"

RgbMenuItem::RgbMenuItem(nn::vi::Display* pDisplay, nn::vi::RgbRange range) NN_NOEXCEPT
    : m_pDisplay(pDisplay)
    , m_Range(range)
{
}

void RgbMenuItem::Render() const NN_NOEXCEPT
{
    NN_LOG("%s", ToString(m_Range));
}

void RgbMenuItem::Select() NN_NOEXCEPT
{
    nn::vi::SetDisplayRgbRange(m_pDisplay, m_Range);
}
