﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/vi.private.h>
#include "IMenuItem.h"

class ModeMenuItem : public IMenuItem
{
public:
    ModeMenuItem(nn::vi::Display* pDisplay, const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT;

    virtual void Render() const NN_NOEXCEPT NN_OVERRIDE;
    virtual void Select() NN_NOEXCEPT NN_OVERRIDE;
private:
    nn::vi::DisplayModeInfo m_Mode;
    nn::vi::Display* m_pDisplay;
};
