﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include "ModeMenuItem.h"
#include "Utility.h"

ModeMenuItem::ModeMenuItem(nn::vi::Display* pDisplay, const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT
    : m_Mode(mode)
    , m_pDisplay(pDisplay)
{
}

void ModeMenuItem::Render() const NN_NOEXCEPT
{
    PrintMode(m_Mode);
}

void ModeMenuItem::Select() NN_NOEXCEPT
{
    // If filling out the mode structure manually and not using the values from nn::vi::ListModes(),
    // please use two decimal places.  The refreshRate value has a tolerance of a thousandth.
    if( nn::vi::SetDisplayMode(m_pDisplay, &m_Mode).IsFailure() )
    {
        NN_LOG("Failed to change mode!\n");
    }
}
