﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/nn_Macro.h>
#include <nn/ae.h>
#include <nn/os.h>

class IMenu;
class Controller;

class MenuManager
{
public:
    class AddMenuHandler
    {
    private:
        MenuManager* m_Manager;
    public:
        explicit AddMenuHandler(MenuManager* manager) NN_NOEXCEPT;
        void operator()(std::unique_ptr<IMenu>&& menu) NN_NOEXCEPT;
    };

    typedef void (*OperationModeHandler)(nn::ae::OperationMode, AddMenuHandler, void* pUserData);
    MenuManager(OperationModeHandler handler, void* pUserData) NN_NOEXCEPT;

    void Update(const Controller& input) NN_NOEXCEPT;
    void Render() const NN_NOEXCEPT;

    void SetOperationMode(nn::ae::OperationMode) NN_NOEXCEPT;
private:
    typedef std::vector<std::unique_ptr<IMenu>> MenuList;
    MenuList m_Menus;

    MenuList::size_type m_MenuIndex;

    mutable nn::os::Mutex m_Lock;
    OperationModeHandler m_Handler;
    void* m_pUserData;

    void Add(std::unique_ptr<IMenu>&& menu) NN_NOEXCEPT;
    void RenderUnsafe() const NN_NOEXCEPT;
};
