﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/vi.private.h>
#include "CmuModeMenuItem.h"
#include "CmuModeMenu.h"
#include "Utility.h"

CmuModeMenu::CmuModeMenu(nn::vi::Display* pDisplay) NN_NOEXCEPT
    : m_pDisplay(pDisplay)
{
}

void CmuModeMenu::RefreshItems() NN_NOEXCEPT
{
    Add(std::make_unique<CmuModeMenuItem>(m_pDisplay, nn::vi::CmuMode_Default));
    Add(std::make_unique<CmuModeMenuItem>(m_pDisplay, nn::vi::CmuMode_InvertColor));
    Add(std::make_unique<CmuModeMenuItem>(m_pDisplay, nn::vi::CmuMode_HighContrast));
    Add(std::make_unique<CmuModeMenuItem>(m_pDisplay, nn::vi::CmuMode_Grayscale));
}

const char* CmuModeMenu::GetName() const NN_NOEXCEPT
{
    return "CMU Modes";
}

void CmuModeMenu::RenderCurrentSetting() const NN_NOEXCEPT
{
    nn::vi::CmuMode mode;

    if( nn::vi::GetDisplayCmuMode(&mode, m_pDisplay).IsSuccess() )
    {
        NN_LOG("%s", ToString(mode));
    }
}
