﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/mem.h>
#include <nvn/nvn.h>
#include <nvn/nvn_FuncPtrInline.h>

class MemoryPool
{
public:
    MemoryPool() NN_NOEXCEPT;
    ~MemoryPool() NN_NOEXCEPT;

    void Initialize(NVNdevice* pDevice, size_t size) NN_NOEXCEPT;

    NVNmemoryPool* GetPool() const NN_NOEXCEPT;
    size_t GetSize() const NN_NOEXCEPT;

    size_t GetAlignedOffset(size_t size, size_t alignment, size_t offset) const NN_NOEXCEPT;
private:
    void* m_Memory;
    NVNmemoryPool* m_Pool;
    size_t m_Size;
};
