﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/vi/vi_CmuLuma.h>
#include "LumaMenu.h"
#include "LumaMenuItem.h"

LumaMenu::LumaMenu(nn::vi::Display* pDisplay) NN_NOEXCEPT
    : m_pDisplay(pDisplay)
{
}

void LumaMenu::RefreshItems() NN_NOEXCEPT
{
    float values[] = { -1.f, -.75f, -.5f, -.25f, 0.f, .25f, .5f, .75f, 1.f };

    for( float value : values )
    {
        std::unique_ptr<IMenuItem> ptr(new LumaMenuItem(m_pDisplay, value));
        Add(ptr);
    }
}

const char* LumaMenu::GetName() const NN_NOEXCEPT
{
    return "Luma Menu";
}

void LumaMenu::RenderCurrentSetting() const NN_NOEXCEPT
{
    float luma;

    if( nn::vi::GetDisplayCmuLuma(&luma, m_pDisplay).IsSuccess() )
    {
        NN_LOG("%f", luma);
    }
    else
    {
        NN_LOG("ERROR");
    }
}
