﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include "IMenu.h"
#include "IMenuItem.h"
#include "Controller.h"

IMenu::IMenu() NN_NOEXCEPT
    : m_CursorIndex(0)
{
}

IMenu::~IMenu() NN_NOEXCEPT
{
}

void IMenu::Refresh() NN_NOEXCEPT
{
    m_CursorIndex = 0;
    m_Items.clear();
    RefreshItems();
    Render();
}

void IMenu::Update(const Controller& input) NN_NOEXCEPT
{
    if( m_Items.size() != 0 )
    {
        if( input.IsPressed<nn::hid::DebugPadButton::Up>() )
        {
            if( m_CursorIndex > 0 )
            {
                --m_CursorIndex;

                Render();
            }
        }

        if( input.IsPressed<nn::hid::DebugPadButton::Down>() )
        {
            if( m_CursorIndex < m_Items.size() - 1 )
            {
                ++m_CursorIndex;

                Render();
            }
        }

        if( input.IsPressed<nn::hid::DebugPadButton::A>() )
        {
            m_Items[m_CursorIndex]->Select();
            Render();
        }
    }
}

void IMenu::Render() const NN_NOEXCEPT
{
    NN_LOG("Current Menu:    %s\n", GetName());
    NN_LOG("Current Setting: ");
    RenderCurrentSetting();
    NN_LOG("\n");

    for( MenuItems::size_type i = 0; i < m_Items.size(); ++i )
    {
        if( i == m_CursorIndex )
        {
            NN_LOG("\t->");
        }
        else
        {
            NN_LOG("\t  ");
        }

        m_Items[i]->Render();
        NN_LOG("\n");
    }

    NN_LOG("\n");
}

void IMenu::Add(std::unique_ptr<IMenuItem>& item) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(item);
    m_Items.push_back(std::move(item));
}
