﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/


//---------------------------------------------
// 定義置き換え
//---------------------------------------------
#ifdef CUSTOM_SHADER_FLAG_0
#define CHANGE_COLOR
#endif

#ifdef CUSTOM_SHADER_FLAG_1
#define CHANGE_POSITION
#endif

#ifdef CUSTOM_SHADER_FLAG_2
#define SAMPLE_LIGHT
#endif

#ifdef CUSTOM_SHADER_FLAG_3
#define CHECK_NORMAL
#endif

#ifdef CUSTOM_SHADER_FLAG_4
#define NORMAL_MAP
#endif

#ifdef CUSTOM_SHADER_FLAG_5
#define SIMPLE_IBL
#endif


//---------------------------------------------
// ユニフォームブロックパラメータ
//---------------------------------------------
layout( std140, binding = SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_0 ) uniform sysCustomShaderUniformBlock0
{
    vec4        param0;
    vec4        param1;
};

//---------------------------------------------
// EffectMakerでデザイナが設定したパラメータ
//---------------------------------------------
#define u_ColorR            sysCustomShaderReservedUniformBlockParam0.x      // カラーR
#define u_ColorG            sysCustomShaderReservedUniformBlockParam0.y      // カラーG
#define u_ColorB            sysCustomShaderReservedUniformBlockParam0.z      // カラーB
#define u_PositionX         sysCustomShaderReservedUniformBlockParam0.w      // 座標X
#define u_PositionY         sysCustomShaderReservedUniformBlockParam1.x      // 座標Y
#define u_PositionZ         sysCustomShaderReservedUniformBlockParam1.y      // 座標Z
#define u_IblUpperR         sysCustomShaderReservedUniformBlockParam1.z      // IBL上方R
#define u_IblUpperG         sysCustomShaderReservedUniformBlockParam1.w      // IBL上方G
#define u_IblUpperB         sysCustomShaderReservedUniformBlockParam2.x      // IBL上方B
#define u_IblLowerR         sysCustomShaderReservedUniformBlockParam2.y      // IBL下方R
#define u_IblLowerG         sysCustomShaderReservedUniformBlockParam2.z      // IBL下方G
#define u_IblLowerB         sysCustomShaderReservedUniformBlockParam2.w      // IBL下方B
