﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

//---------------------------------------------
// フラグメントシェーダから送られてきた値
//---------------------------------------------
in vec4 gcShaderFragmentParam;        // Color

//---------------------------------------------
// テクスチャ1を法線マップとして利用するのでキャンセルする
//---------------------------------------------
#ifdef NORMAL_MAP
#define USE_USR_BLEND_TEXTURE1_COLOR
vec4 BlendTexture1Color( vec4 texture0, vec4 texture1 )
{
    return texture0;
}
#endif

//---------------------------------------------
// 最終出力カラー調整
//---------------------------------------------
#define USE_USR_FINAL_ADJUSTMENT_FRAGMENT_COLOR
void FinalAdjustmentFragmentColor()
{
#ifdef CHANGE_COLOR
    // カラーを変更
    OUTPUT_COLOR.rgb *= vec3( u_ColorR, u_ColorG, u_ColorB );
#endif

#ifdef SAMPLE_LIGHT
    // 頂点シェーダで行ったライティング結果の適用
    OUTPUT_COLOR.rgb *= gcShaderFragmentParam.x;
#endif


#ifdef NORMAL_MAP
    // 法線マップを使用

    // 法線マップテクスチャカラーを取得する
    vec3 normalFromMap = texture2D( sysTextureSampler1, sysInTexCoord1 ).xyz;

    normalFromMap.z = sqrt( clamp(
                    1.0 -( normalFromMap.x * normalFromMap.x + normalFromMap.y * normalFromMap.y ), 0.0, 1.0 ) );
    vec3 normal = normalFromMap.x * sysWorldTangentVary  +
                  normalFromMap.y * sysWorldBinormalVary +
                  normalFromMap.z * sysWorldNormalVary;
    normal = normalize( normal );
#else
    // 法線マップを使用しない
    vec3  normal = sysWorldNormalVary;
#endif


#ifdef SIMPLE_IBL
    // 簡単な Imabe Based Lighting サンプル。縦方向グラデーションでライティングを行う
    vec3  upper = vec3( u_IblUpperR, u_IblUpperG, u_IblUpperB );
    vec3  lower = vec3( u_IblLowerR, u_IblLowerG, u_IblLowerB );
    vec3 iblColor = mix( lower, upper, ( normal.y * 0.5 + 0.5 ) );
    OUTPUT_COLOR.xyz *= iblColor;
#endif


#ifdef NORMAL_MAP
    // 法線マップによるライティング
    vec3 lightWorldPos = vec3( 0.0, 100, 100 );
    vec3 position      = vec3( sysViewMatrix * vec4( sysWorldPositionVary, 1.0 ) );
    vec3 lightPos      = vec3( sysViewMatrix * vec4( lightWorldPos, 1 ) );
    vec3 lightVec      = normalize( lightPos - position );
    vec3 viewNormal    = normalize( ( sysViewMatrix * vec4( normal, 1 ) ).xyz );

    float diffuse = dot( lightVec, viewNormal );
    diffuse = clamp( diffuse, 0.3, 1.0 );
    OUTPUT_COLOR.xyz *= diffuse;
#endif

    // 全てのシェーダでの共通処理
    CommonFragmentProcess();

#ifdef CHECK_NORMAL
    // 法線を可視化する場合、最終結果を法線の値で上書き
    OUTPUT_COLOR.xyz = normal;
#endif
}

