﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_MathTypes.h>
#include <nn/vfx/vfx_Data.h>

/// <?xml version="1.0" encoding="UTF-8"?>
/// <UserDataDefinition Kind="CustomShader"
///                     Name="Full UI Sample"
///                     Version="0">
///   <ParameterDefinition Name="シェーダ分岐フラグ"
///                        Type="CheckButtons"
///                        BuiltInMember="ShaderFlags">
///     <!-- チェックボックスの初期値は Option 要素の Selected 属性で指定します -->
///     <!-- 初期状態で ON にしたい要素の属性を true にしてください -->
///     <!-- 下記の例は三番目までのチェックボックスを ON にします -->
///     <OptionGroup>
///       <!-- BitIndex 属性の指定は任意で、0 始まりです -->
///       <Option BitIndex="0"  UniqueKey="change_color" Value="Change Color" Selected="true" />
///       <Option BitIndex="1"  UniqueKey="change_position" Value="Change Position" Selected="true" />
///       <Option BitIndex="2"  UniqueKey="sample_light" Value="Sample Light" Selected="true" />
///       <Option BitIndex="3"  UniqueKey="check_normal" Value="Check Normal" />
///       <Option BitIndex="4"  UniqueKey="normal_map" Value="NormalMap" />
///       <Option BitIndex="5"  UniqueKey="simple_ibl" Value="SimpleIbl" />
///       <Option BitIndex="6"  UniqueKey="flag_06" Value="Flag06" />
///       <Option BitIndex="7"  UniqueKey="flag_07" Value="Flag07" />
///       <Option BitIndex="8"  UniqueKey="flag_08" Value="Flag08" />
///       <Option BitIndex="9"  UniqueKey="flag_09" Value="Flag09" />
///       <Option BitIndex="10" UniqueKey="flag_10" Value="Flag10" />
///       <Option BitIndex="11" UniqueKey="flag_11" Value="Flag11" />
///       <Option BitIndex="12" UniqueKey="flag_12" Value="Flag12" />
///       <Option BitIndex="13" UniqueKey="flag_13" Value="Flag13" />
///       <Option BitIndex="14" UniqueKey="flag_14" Value="Flag14" />
///       <Option BitIndex="15" UniqueKey="flag_15" Value="Flag15" />
///       <Option BitIndex="16" UniqueKey="flag_16" Value="Flag16" />
///       <Option BitIndex="17" UniqueKey="flag_17" Value="Flag17" />
///       <Option BitIndex="18" UniqueKey="flag_18" Value="Flag18" />
///       <Option BitIndex="19" UniqueKey="flag_19" Value="Flag19" />
///       <Option BitIndex="20" UniqueKey="flag_20" Value="Flag20" />
///       <Option BitIndex="21" UniqueKey="flag_21" Value="Flag21" />
///       <Option BitIndex="22" UniqueKey="flag_22" Value="Flag22" />
///       <Option BitIndex="23" UniqueKey="flag_23" Value="Flag23" />
///       <Option BitIndex="24" UniqueKey="flag_24" Value="Flag24" />
///       <Option BitIndex="25" UniqueKey="flag_25" Value="Flag25" />
///       <Option BitIndex="26" UniqueKey="flag_26" Value="Flag26" />
///       <Option BitIndex="27" UniqueKey="flag_27" Value="Flag27" />
///       <Option BitIndex="28" UniqueKey="flag_28" Value="Flag28" />
///       <Option BitIndex="29" UniqueKey="flag_29" Value="Flag29" />
///       <Option BitIndex="30" UniqueKey="flag_30" Value="Flag30" />
///       <Option BitIndex="31" UniqueKey="flag_31" Value="Flag31" />
///       <Option BitIndex="32" UniqueKey="flag_32" Value="Flag32" />
///       <Option BitIndex="33" UniqueKey="flag_33" Value="Flag33" />
///       <Option BitIndex="34" UniqueKey="flag_34" Value="Flag34" />
///       <Option BitIndex="35" UniqueKey="flag_35" Value="Flag35" />
///       <Option BitIndex="36" UniqueKey="flag_36" Value="Flag36" />
///       <Option BitIndex="37" UniqueKey="flag_37" Value="Flag37" />
///       <Option BitIndex="38" UniqueKey="flag_38" Value="Flag38" />
///       <Option BitIndex="39" UniqueKey="flag_39" Value="Flag39" />
///       <Option BitIndex="40" UniqueKey="flag_40" Value="Flag40" />
///       <Option BitIndex="41" UniqueKey="flag_41" Value="Flag41" />
///       <Option BitIndex="42" UniqueKey="flag_42" Value="Flag42" />
///       <Option BitIndex="43" UniqueKey="flag_43" Value="Flag43" />
///       <Option BitIndex="44" UniqueKey="flag_44" Value="Flag44" />
///       <Option BitIndex="45" UniqueKey="flag_45" Value="Flag45" />
///       <Option BitIndex="46" UniqueKey="flag_46" Value="Flag46" />
///       <Option BitIndex="47" UniqueKey="flag_47" Value="Flag47" />
///       <Option BitIndex="48" UniqueKey="flag_48" Value="Flag48" />
///       <Option BitIndex="49" UniqueKey="flag_49" Value="Flag49" />
///       <Option BitIndex="50" UniqueKey="flag_50" Value="Flag50" />
///       <Option BitIndex="51" UniqueKey="flag_51" Value="Flag51" />
///       <Option BitIndex="52" UniqueKey="flag_52" Value="Flag52" />
///       <Option BitIndex="53" UniqueKey="flag_53" Value="Flag53" />
///       <Option BitIndex="54" UniqueKey="flag_54" Value="Flag54" />
///       <Option BitIndex="55" UniqueKey="flag_55" Value="Flag55" />
///       <Option BitIndex="56" UniqueKey="flag_56" Value="Flag56" />
///       <Option BitIndex="57" UniqueKey="flag_57" Value="Flag57" />
///       <Option BitIndex="58" UniqueKey="flag_58" Value="Flag58" />
///       <Option BitIndex="59" UniqueKey="flag_59" Value="Flag59" />
///       <Option BitIndex="60" UniqueKey="flag_69" Value="Flag60" />
///       <Option BitIndex="61" UniqueKey="flag_61" Value="Flag61" />
///       <Option BitIndex="62" UniqueKey="flag_62" Value="Flag62" />
///       <Option BitIndex="63" UniqueKey="flag_63" Value="Flag63" />
///     </OptionGroup>
///   </ParameterDefinition>
///   <ParameterDefinition Name="RadioButton Sample0"
///                        Type="RadioButtons"
///                        BuiltInMember="ShaderSwitch0">
///     <!-- ラジオボタンの初期値は Option 要素の Selected 属性で指定します -->
///     <!-- 初期状態で選択したい要素の属性を true にしてください -->
///     <OptionGroup>
///       <Option UniqueKey="a_0" Value="A0" Selected="true" />
///       <Option UniqueKey="b_0" Value="B0" />
///       <Option UniqueKey="c_0" Value="C0" />
///       <Option UniqueKey="d_0" Value="D0" />
///       <Option UniqueKey="e_0" Value="E0" />
///       <Option UniqueKey="f_0" Value="F0" />
///       <Option UniqueKey="g_0" Value="G0" />
///       <Option UniqueKey="h_0" Value="H0" />
///     </OptionGroup>
///   </ParameterDefinition>
///   <ParameterDefinition Name="RadioButton Sample1"
///                        Type="RadioButtons"
///                        BuiltInMember="ShaderSwitch1">
///     <!-- ラジオボタンの初期値は Option 要素の Selected 属性で指定します -->
///     <!-- 初期状態で選択したい要素の属性を true にしてください -->
///     <OptionGroup>
///       <Option UniqueKey="a_1" Value="A1" />
///       <Option UniqueKey="b_1" Value="B1" Selected="true" />
///       <Option UniqueKey="c_1" Value="C1" />
///       <Option UniqueKey="d_1" Value="D1" />
///       <Option UniqueKey="e_1" Value="E1" />
///       <Option UniqueKey="f_1" Value="F1" />
///       <Option UniqueKey="g_1" Value="G1" />
///       <Option UniqueKey="h_1" Value="H1" />
///     </OptionGroup>
///   </ParameterDefinition>
///   <ParameterDefinition Name="RadioButton Sample2"
///                        Type="RadioButtons"
///                        BuiltInMember="ShaderSwitch2">
///     <!-- ラジオボタンの初期値は Option 要素の Selected 属性で指定します -->
///     <!-- 初期状態で選択したい要素の属性を true にしてください -->
///     <OptionGroup>
///       <Option UniqueKey="a_2" Value="A2" />
///       <Option UniqueKey="b_2" Value="B2" />
///       <Option UniqueKey="c_2" Value="C2" Selected="true" />
///       <Option UniqueKey="d_2" Value="D2" />
///       <Option UniqueKey="e_2" Value="E2" />
///       <Option UniqueKey="f_2" Value="F2" />
///       <Option UniqueKey="g_2" Value="G2" />
///       <Option UniqueKey="h_2" Value="H2" />
///     </OptionGroup>
///   </ParameterDefinition>
///   <ParameterDefinition Name="RadioButton Sample3"
///                        Type="RadioButtons"
///                        BuiltInMember="ShaderSwitch3">
///     <!-- ラジオボタンの初期値は Option 要素の Selected 属性で指定します -->
///     <!-- 初期状態で選択したい要素の属性を true にしてください -->
///     <OptionGroup>
///       <Option UniqueKey="a_3" Value="A3" />
///       <Option UniqueKey="b_3" Value="B3" />
///       <Option UniqueKey="c_3" Value="C3" />
///       <Option UniqueKey="d_3" Value="D3" Selected="true" />
///       <Option UniqueKey="e_3" Value="E3" />
///       <Option UniqueKey="f_3" Value="F3" />
///       <Option UniqueKey="g_3" Value="G3" />
///       <Option UniqueKey="h_3" Value="H3" />
///     </OptionGroup>
///   </ParameterDefinition>
///   <ParameterDefinition Name="RadioButton Sample4"
///                        Type="RadioButtons"
///                        BuiltInMember="ShaderSwitch4">
///     <!-- ラジオボタンの初期値は Option 要素の Selected 属性で指定します -->
///     <!-- 初期状態で選択したい要素の属性を true にしてください -->
///     <OptionGroup>
///       <Option UniqueKey="a_4" Value="A4" />
///       <Option UniqueKey="b_4" Value="B4" />
///       <Option UniqueKey="c_4" Value="C4" />
///       <Option UniqueKey="d_4" Value="D4" />
///       <Option UniqueKey="e_4" Value="E4" Selected="true" />
///       <Option UniqueKey="f_4" Value="F4" />
///       <Option UniqueKey="g_4" Value="G4" />
///       <Option UniqueKey="h_4" Value="H4" />
///     </OptionGroup>
///   </ParameterDefinition>
///   <ParameterDefinition Name="RadioButton Sample5"
///                        Type="RadioButtons"
///                        BuiltInMember="ShaderSwitch5">
///     <!-- ラジオボタンの初期値は Option 要素の Selected 属性で指定します -->
///     <!-- 初期状態で選択したい要素の属性を true にしてください -->
///     <OptionGroup>
///       <Option UniqueKey="a_5" Value="A5" />
///       <Option UniqueKey="b_5" Value="B5" />
///       <Option UniqueKey="c_5" Value="C5" />
///       <Option UniqueKey="d_5" Value="D5" />
///       <Option UniqueKey="e_5" Value="E5" />
///       <Option UniqueKey="f_5" Value="F5" Selected="true" />
///       <Option UniqueKey="g_5" Value="G5" />
///       <Option UniqueKey="h_5" Value="H5" />
///     </OptionGroup>
///   </ParameterDefinition>
///   <ParameterDefinition Name="RadioButton Sample6"
///                        Type="RadioButtons"
///                        BuiltInMember="ShaderSwitch6">
///     <!-- ラジオボタンの初期値は Option 要素の Selected 属性で指定します -->
///     <!-- 初期状態で選択したい要素の属性を true にしてください -->
///     <OptionGroup>
///       <Option UniqueKey="a_6" Value="A6" />
///       <Option UniqueKey="b_6" Value="B6" />
///       <Option UniqueKey="c_6" Value="C6" />
///       <Option UniqueKey="d_6" Value="D6" />
///       <Option UniqueKey="e_6" Value="E6" />
///       <Option UniqueKey="f_6" Value="F6" />
///       <Option UniqueKey="g_6" Value="G6" Selected="true" />
///       <Option UniqueKey="h_6" Value="H6" />
///     </OptionGroup>
///   </ParameterDefinition>
///   <ParameterDefinition Name="RadioButton Sample7"
///                        Type="RadioButtons"
///                        BuiltInMember="ShaderSwitch7">
///     <!-- ラジオボタンの初期値は Option 要素の Selected 属性で指定します -->
///     <!-- 初期状態で選択したい要素の属性を true にしてください -->
///     <OptionGroup>
///       <Option UniqueKey="a_7" Value="A7" />
///       <Option UniqueKey="b_7" Value="B7" />
///       <Option UniqueKey="c_7" Value="C7" />
///       <Option UniqueKey="d_7" Value="D7" />
///       <Option UniqueKey="e_7" Value="E7" />
///       <Option UniqueKey="f_7" Value="F7" />
///       <Option UniqueKey="g_7" Value="G7" />
///       <Option UniqueKey="h_7" Value="H7" Selected="true" />
///     </OptionGroup>
///   </ParameterDefinition>
struct ResFullCustomShaderSample
{
///   <!-- カラー: RGB -->
///   <ParameterDefinition Name="カラー" Type="ColorRgb">
///     <ColorSetting Default="1 0.7 0.5" />
    nn::util::Float3  color;
///   </ParameterDefinition>

///
///   <!-- 加算する位置: xyz -->
///   <ParameterDefinition Name="加算する位置" Type="Slider3f">
///     <SliderSetting Default="0.0 10.0 0.0" Minimum="-1000000.0" Maximum="1000000.0" Step="0.1" />
    nn::util::Float3  pos;
///   </ParameterDefinition>

///   <!-- IBLカラー0: RGB -->
///   <ParameterDefinition Name="IBLカラー0" Type="ColorRgb">
///     <ColorSetting Default="0.3 1.0 1.0" />
    nn::util::Float3  iblColor0;
///   </ParameterDefinition>

///   <!-- IBLカラー1: RGB -->
///   <ParameterDefinition Name="IBLカラー1" Type="ColorRgb">
///     <ColorSetting Default="0.3 0.3 0.0" />
    nn::util::Float3  iblColor1;
///   </ParameterDefinition>

///   <!-- RGBA -->
///   <ParameterDefinition Name="Float4カラー" Type="ColorRgba">
///     <ColorSetting Default="0.3 0.6 0.9 1.0" />
    nn::util::Float4  colorRgba;
///   </ParameterDefinition>

///   <!-- A -->
///   <ParameterDefinition Name="floatアルファ" Type="ColorA">
///     <ColorSetting Default="0.5" />
    float  colorA;
///   </ParameterDefinition>

///   <!-- カラーアニメ: RGB -->
///   <ParameterDefinition Name="RGBアニメ" Type="ColorAnimeRgb">
///     <ColorSetting Default="1.0 1.0 1.0" />
    nn::vfx::detail::ResAnim8KeyParamSet  colorAnime;
///   </ParameterDefinition>

///   <!-- カラーアニメ: A -->
///   <ParameterDefinition Name="アルファアニメ" Type="ColorAnimeA">
///     <ColorSetting Default="1.0" />
    nn::vfx::detail::ResAnim8KeyParamSet  alphaAnime;
///   </ParameterDefinition>

///   <!-- float 1要素 スライダー -->
///   <ParameterDefinition Name="Slider1f サンプル" Type="Slider1f">
///     <SliderSetting Default="0" Minimum="-1000000.0" Maximum="1000000.0" Step="1" />
    float  slider1f;
///   </ParameterDefinition>

///   <!-- float 2要素 スライダー -->
///   <ParameterDefinition Name="Slider2f サンプル" Type="Slider2f">
///     <SliderSetting Default="0 0" Minimum="-1000000.0" Maximum="1000000.0" Step="1" />
    nn::util::Float2  slider2f;
///   </ParameterDefinition>

///   <!-- float 3要素 スライダー -->
///   <ParameterDefinition Name="Slider3f サンプル" Type="Slider3f">
///     <SliderSetting Default="0 0 0" Minimum="-1000000.0" Maximum="1000000.0" Step="1" />
    nn::util::Float3  slider3f;
///   </ParameterDefinition>

///   <!-- float 4要素 スライダー -->
///   <ParameterDefinition Name="Slider4f サンプル" Type="Slider4f">
///     <SliderSetting Default="0 0 0 0" Minimum="-1000000.0" Maximum="1000000.0" Step="1" />
    nn::util::Float4  slider4f;
///   </ParameterDefinition>

///   <!-- int 1要素 スライダー -->
///   <ParameterDefinition Name="Slider1i サンプル" Type="Slider1i">
///     <SliderSetting Default="0" Minimum="-1000000" Maximum="1000000" Step="1" />
    float  slider1i;
///   </ParameterDefinition>

///   <!-- int 2要素 スライダー -->
///   <ParameterDefinition Name="Slider2i サンプル" Type="Slider2i">
///     <SliderSetting Default="0 0" Minimum="-1000000.0" Maximum="1000000.0" Step="1" />
    nn::util::Float2  slider2i;
///   </ParameterDefinition>

///   <!-- int 3要素 スライダー -->
///   <ParameterDefinition Name="Slider3i サンプル" Type="Slider3i">
///     <SliderSetting Default="0 0 0" Minimum="-1000000.0" Maximum="1000000.0" Step="1" />
    nn::util::Float3  slider3i;
///   </ParameterDefinition>

///   <!-- int 4要素 スライダー -->
///   <ParameterDefinition Name="Slider4i サンプル" Type="Slider4i">
///     <SliderSetting Default="0 0 0 0" Minimum="-1000000.0" Maximum="1000000.0" Step="1" />
    nn::util::Float4  slider4i;
///   </ParameterDefinition>

///   <!-- チェックボックス -->
///   <ParameterDefinition Name="フラグ" Type="CheckButtons" NeedReload="true">
///     <!-- (非推奨)チェックボックスの初期値は、OptionGroup 要素の Default 属性でも指定できます -->
///     <!-- その場合は、該当するビットが立っている値を 10進数で指定します -->
///     <!-- 下記の例は (1+2+4) = 7 で、BitIndex が 0,1,2 のチェックボックスを ON にします -->
///     <OptionGroup Default="7">
///       <!-- BitIndex を指定した要素と省略した要素が混在している場合、前の要素の値に 1 ずつ加算した値が割り振られます -->
///       <!-- 最初の要素が省略されている場合は 0 となります(C/C++ の enum と類似した挙動です) -->
///       <Option BitIndex="10" UniqueKey="switch_01" Value="スイッチ 01" />
///       <Option UniqueKey="switch_02" Value="スイッチ 02" />
///       <Option UniqueKey="switch_03" Value="スイッチ 03" />
///       <Option UniqueKey="switch_04" Value="スイッチ 04" />
///       <Option UniqueKey="switch_05" Value="スイッチ 05" />
///       <Option UniqueKey="switch_06" Value="スイッチ 06" />
///       <Option UniqueKey="switch_07" Value="スイッチ 07" />
///       <Option UniqueKey="switch_08" Value="スイッチ 08" />
///       <Option UniqueKey="switch_09" Value="スイッチ 09" />
///       <Option UniqueKey="switch_10" Value="スイッチ 10" />
///       <Option BitIndex="0" UniqueKey="switch_11" Value="スイッチ 11" />
///       <Option UniqueKey="switch_12" Value="スイッチ 12" />
///       <Option UniqueKey="switch_13" Value="スイッチ 13" />
///       <Option UniqueKey="switch_14" Value="スイッチ 14" />
///       <Option UniqueKey="switch_15" Value="スイッチ 15" />
///       <Option UniqueKey="switch_16" Value="スイッチ 16" />
///       <Option UniqueKey="switch_17" Value="スイッチ 17" />
///       <Option UniqueKey="switch_18" Value="スイッチ 18" />
///       <Option UniqueKey="switch_19" Value="スイッチ 19" />
///       <Option UniqueKey="switch_20" Value="スイッチ 20" />
///       <Option BitIndex="20" UniqueKey="switch_21" Value="スイッチ 21" />
///       <Option BitIndex="21" UniqueKey="switch_22" Value="スイッチ 22" />
///       <Option BitIndex="22" UniqueKey="switch_23" Value="スイッチ 23" />
///       <Option BitIndex="23" UniqueKey="switch_24" Value="スイッチ 24" />
///       <Option BitIndex="24" UniqueKey="switch_25" Value="スイッチ 25" />
///       <Option BitIndex="25" UniqueKey="switch_26" Value="スイッチ 26" />
///       <Option BitIndex="26" UniqueKey="switch_27" Value="スイッチ 27" />
///       <Option BitIndex="27" UniqueKey="switch_28" Value="スイッチ 28" />
///       <Option BitIndex="28" UniqueKey="switch_29" Value="スイッチ 29" />
///       <Option BitIndex="29" UniqueKey="switch_30" Value="スイッチ 30" />
///       <Option BitIndex="30" UniqueKey="switch_31" Value="スイッチ 31" />
///       <Option BitIndex="31" UniqueKey="switch_32" Value="スイッチ 32" />
///     </OptionGroup>
    unsigned int    choices_check;
///   </ParameterDefinition>

///   <!-- ラジオボタン -->
///   <ParameterDefinition Name="選択肢" Type="RadioButtons">
///     <!-- (非推奨)ラジオボタンの初期値は、OptionGroup 要素の Default 属性でも指定できます -->
///     <!-- その場合は、該当するビットが立っている値を 10進数で指定します -->
///     <!-- 1番目～8番目の選択肢に、それぞれ 1,2,4,8,16,32,64,128 が対応します -->
///     <OptionGroup Default="8">
///       <Option UniqueKey="radio_01" Value="選択肢 01" />
///       <Option UniqueKey="radio_02" Value="選択肢 02" />
///       <Option UniqueKey="radio_03" Value="選択肢 03" />
///       <Option UniqueKey="radio_04" Value="選択肢 04" />
///       <Option UniqueKey="radio_05" Value="選択肢 05" />
///       <Option UniqueKey="radio_06" Value="選択肢 06" />
///       <Option UniqueKey="radio_07" Value="選択肢 07" />
///       <Option UniqueKey="radio_08" Value="選択肢 08" />
///       <Option UniqueKey="radio_09" Value="選択肢 09" />
///       <Option UniqueKey="radio_10" Value="選択肢 10" />
///       <Option UniqueKey="radio_11" Value="選択肢 11" />
///       <Option UniqueKey="radio_12" Value="選択肢 12" />
///       <Option UniqueKey="radio_13" Value="選択肢 13" />
///       <Option UniqueKey="radio_14" Value="選択肢 14" />
///       <Option UniqueKey="radio_15" Value="選択肢 15" />
///       <Option UniqueKey="radio_16" Value="選択肢 16" />
///       <Option UniqueKey="radio_17" Value="選択肢 17" />
///       <Option UniqueKey="radio_18" Value="選択肢 18" />
///       <Option UniqueKey="radio_19" Value="選択肢 19" />
///       <Option UniqueKey="radio_20" Value="選択肢 20" />
///       <Option UniqueKey="radio_21" Value="選択肢 21" />
///       <Option UniqueKey="radio_22" Value="選択肢 22" />
///       <Option UniqueKey="radio_23" Value="選択肢 23" />
///       <Option UniqueKey="radio_24" Value="選択肢 24" />
///       <Option UniqueKey="radio_25" Value="選択肢 25" />
///       <Option UniqueKey="radio_26" Value="選択肢 26" />
///       <Option UniqueKey="radio_27" Value="選択肢 27" />
///       <Option UniqueKey="radio_28" Value="選択肢 28" />
///       <Option UniqueKey="radio_29" Value="選択肢 29" />
///       <Option UniqueKey="radio_30" Value="選択肢 30" />
///       <Option UniqueKey="radio_31" Value="選択肢 31" />
///       <Option UniqueKey="radio_32" Value="選択肢 32" />
///     </OptionGroup>
    unsigned int    choices_radio;
///   </ParameterDefinition>

///   <!-- 文字列コンボボックス -->
///   <ParameterDefinition Name="ユーザー定義文字列" Type="StringComboBox">
///     <OptionGroup>
///       <Option Value="UserDefinitionString1" UniqueKey="String1" />
///       <Option Value="UserDefinitionString2" UniqueKey="String2" />
///       <Option Value="UserDefinitionString3" UniqueKey="String3" />
///     </OptionGroup>
    unsigned char    usr_string_combo[ 32 ];
///   </ParameterDefinition>

///   <!-- 整数値コンボボックス -->
///   <ParameterDefinition Name="ユーザー定義整数値" Type="IntComboBox">
///     <OptionGroup>
///       <Option BitIndex="5" Value="UserDefinitionInteger1" UniqueKey="String1" Selected="True" />
///       <Option BitIndex="7" Value="UserDefinitionInteger2" UniqueKey="String2" />
///       <Option BitIndex="1" Value="UserDefinitionInteger3" UniqueKey="String3" />
///     </OptionGroup>
    int     usr_int_combo;
///   </ParameterDefinition>

///   <!-- テキストボックス -->
///   <ParameterDefinition Name="テキストボックス文字列" Type="TextBox">
///     <TextSetting Default="Text Sample" RowCount="1" />
    unsigned char    user_string_textbox[ 32 ];
///   </ParameterDefinition>
};
///   <!-- EffectMaker 上での UI レイアウト設定 -->
///   <UILayout>
///     <!-- 上段の定義では存在するデータを、UI 定義をしないことで隠すこともできます -->
///     <Group Name="{Localize JP='パラメータ', EN='Shader Paramter'}">
///       <Parameter Member="color" />
///       <Parameter Member="pos" />
///       <Parameter Member="iblColor0" />
///       <Parameter Member="iblColor1" />
///       <Parameter Member="colorAnime" />
///       <Parameter Member="alphaAnime" />
///       <Parameter Member="colorRgba" />
///       <Parameter Member="colorA" />
///     </Group>
///     <Group Name="{Localize JP='シェーダキー', EN='Shader Key'}">
///       <Parameter Member="ShaderFlags" />
///     </Group>
///     <Group Name="{Localize JP='シェーダ分岐', EN='Shader Switch'}">
///       <Parameter Member="ShaderSwitch0" />
///       <Parameter Member="ShaderSwitch1" />
///       <Parameter Member="ShaderSwitch2" />
///       <Parameter Member="ShaderSwitch3" />
///       <Parameter Member="ShaderSwitch4" />
///       <Parameter Member="ShaderSwitch5" />
///       <Parameter Member="ShaderSwitch6" />
///       <Parameter Member="ShaderSwitch7" />
///     </Group>
///     <Group Name="{Localize JP='スライダーサンプル', EN='Slider Samples'}">
///       <Parameter Member="slider1f" />
///       <Parameter Member="slider2f" />
///       <Parameter Member="slider3f" />
///       <Parameter Member="slider4f" />
///       <Parameter Member="slider1i" />
///       <Parameter Member="slider2i" />
///       <Parameter Member="slider3i" />
///       <Parameter Member="slider4i" />
///     </Group>
///     <Group Name="{Localize JP='チェックボックスサンプル', EN='ChecckButton Samples'}">
///       <Parameter Member="choices_check" />
///     </Group>
///     <Group Name="{Localize JP='ラジオボタンサンプル', EN='RadioButton Samples'}">
///       <Parameter Member="choices_radio" />
///     </Group>
///     <Group Name="{Localize JP='テキストボックスサンプル', EN='TextBox Samples'}">
///       <Parameter Member="usr_string_combo" />
///       <Parameter Member="user_string_textbox" />
///       <Parameter Member="usr_int_combo" />
///     </Group>
///   </UILayout>
/// </UserDataDefinition>
