﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{SjisEncoding.h,PageSampleUtilConvertSjis}
 *
 * @brief
 *  Shift_JIS と UTF-16 の相互変換関数のインターフェイス定義
 */

#pragma once

#include <stdint.h>
#include <nn/util/util_CharacterEncodingResult.h>

//
// 文字コードを Shift_JIS から UTF-16 に変換します。終端文字まで変換されます。
//
nn::util::CharacterEncodingResult ConvertStringSjisToUtf16(uint16_t *pDst, int dstLength, const char *pSrc);

//
// 文字コードを UTF-16 から Shift_JIS に変換します。終端文字まで変換されます。
//
nn::util::CharacterEncodingResult ConvertStringUtf16ToSjis(char *pDst, int dstLength, const uint16_t *pSrc);
