﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d.h>

#include "Ui2dTextureChange.h"

//------------------------------------------------------------------------------
//  変数の宣言
//------------------------------------------------------------------------------

// テクスチャ情報（テクスチャを差し替える際に利用します）
static nn::ui2d::PlacementTextureInfo*      g_pPlacementTextureInfo;

//------------------------------------------------------------------------------
// 初期化
//------------------------------------------------------------------------------
void InitializeTextureChange()
{
    nn::gfx::Device* pDevice = g_GfxFramework.GetDevice();

    // テクスチャを読み込んで、動的に変更します。
    // 読み込むテクスチャは、アーカイブ作成の直前に ftxb 形式のファイルを、バイナリコンバーターの画像出力フォルダにコピーしています。
    // (./Resources 以下のコンバートバッチファイルを参照してください)
    const nn::ui2d::TextureInfo* pInfo = g_pArcResourceAccessor->AcquireTexture(pDevice, "SampleTexture");
    NN_ASSERT_NOT_NULL(pInfo);
    NN_ASSERT(pInfo->IsValid(), "Can't load texture !!!");


    g_pPlacementTextureInfo = AllocAndConstruct<nn::ui2d::PlacementTextureInfo>();
    g_pPlacementTextureInfo->Set(*pInfo);
    g_pPlacementTextureInfo->ResetTextureDescriptorSlot();

    // スロットを設定します。
    RegisterSlotForTexture(g_pPlacementTextureInfo->GetTextureDescriptorSlot(), *pInfo->GetTextureView(), &g_GfxFramework);
}

//------------------------------------------------------------------------------
// 解放
//------------------------------------------------------------------------------
void FinalizeTextureChange()
{
    nn::gfx::Device* pDevice = g_GfxFramework.GetDevice();

    g_pPlacementTextureInfo->Finalize(pDevice);
    DestructAndFree<nn::ui2d::PlacementTextureInfo>(g_pPlacementTextureInfo);
    g_pPlacementTextureInfo = NULL;
}

//------------------------------------------------------------------------------
// 計算処理
//------------------------------------------------------------------------------
void CalculateTextureChange(int frame)
{
    if (frame == 60 * 3)
    {
        nn::ui2d::Pane* pTargetPane = g_pLayout->GetRootPane()->FindPaneByName("picture_ts");
        NN_ASSERT_NOT_NULL(pTargetPane);
        pTargetPane->GetMaterial()->SetTexMap(0, g_pPlacementTextureInfo);
    }
}
