﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/font.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include "Ui2dCommon.h"

//------------------------------------------------------------------------------
//
// MultiArcResourceAccessor 関連処理です。
//
//------------------------------------------------------------------------------

// 初期化
void InitializeMultiArcResource();

// 解放
void FinalizeMultiArcResource();

// 計算処理
void CalculateMultiArcResource(int frame);

// レイアウトの計算処理
void CalculateMultiArcResourceLayout();

// レイアウトの描画処理
void DrawMultiArcResourceLayout(nn::gfx::CommandBuffer* pCmdBuffer);
