﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/gfx.h>

#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nns/gfx/gfx_GraphicsFramework.h>

class ApplicationHeap;

class Capture
{
    NN_DISALLOW_COPY( Capture );
    NN_DISALLOW_MOVE( Capture );

private:
    ApplicationHeap* m_pApplicationHeap;

    nns::gfx::GraphicsFramework* m_pGraphicsSystem;

    //
    nn::gfx::MemoryPool m_MemoryPool;
    void* m_pMemoryPool;
    ptrdiff_t m_pMemoryPoolOffset;
    ptrdiff_t m_pMemoryPoolCommandOffset;

    //
    nn::gfx::MemoryPool m_TextureMemoryPool;
    void* m_pTexturePoolMemory;
    ptrdiff_t m_pTextureMemoryPoolOffset;

    //
    nn::gfx::Texture m_Texture;
    nn::gfx::TextureView g_TextureView;
    //nn::gfx::DescriptorSlot g_TextureDescriptorSlot;
    int m_TextureSlot;

    //
    //nn::gfx::Sampler g_Sampler;
    //nn::gfx::DescriptorSlot g_SamplerDescriptorSlot;
    int m_SamplerSlot;

    //
    nn::gfx::Buffer m_Buffer;

public:
    Capture() NN_NOEXCEPT;

    void Initialize(
        ApplicationHeap* pApplicationHeap,
        nns::gfx::GraphicsFramework* pGraphicsSystem) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    void Set( void* pBuf );

    void Draw( nns::gfx::PrimitiveRenderer::Renderer* pRenderer, int bufferIndex ) NN_NOEXCEPT;

private:
    void InitializeGfxMemoryPool() NN_NOEXCEPT;
    void InitializeGfxTexture() NN_NOEXCEPT;
    void InitializeGfxTextureView() NN_NOEXCEPT;
    void InitializeGfxBuffer() NN_NOEXCEPT;
};
