﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio.h>
#include <nn/mem.h>

// Audio を初期化します。
void InitializeAudio(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;

// Audio を終了します。
void FinalizeAudio(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;

// AudioRendererParameter を取得します。
nn::audio::AudioRendererParameter GetAudioRendererParameter() NN_NOEXCEPT;

// Audio パフォーマンス計測を初期化します。
void InitializeAudioPerformanceMetrics(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;

// Audio パフォーマンス計測を終了します。
void FinalizeAudioPerformanceMetrics(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;

// Audio 波形データの読み出しを初期化します。
void InitializeCircularBufferSink(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;

// Audio 波形データの読み出しを終了します。
void FinalizeCircularBufferSink(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;

// AudioRenderer イベントがシグナル状態になるまで Wait します。
void WaitAudioRendererEvent() NN_NOEXCEPT;

// AudioRenderer 更新を要求します。
void RequestUpdateAudioRenderer() NN_NOEXCEPT;

// 指定インデックスの SE を再生します。
bool PlaySe(int index) NN_NOEXCEPT;

// リバーブの ON / OFF 状態を取得します。
bool IsEnableReverb() NN_NOEXCEPT;

// リバーブの ON / OFF を切り替えます。
void EnableReverb(bool enable) NN_NOEXCEPT;

// オーディオパフォーマンス情報の取得に必要なバッファサイズを取得します。
size_t GetRequiredBufferSizeForAudioPerformanceFrames() NN_NOEXCEPT;

// オーディオパフォーマンスバッファを切り替え、直近で収集したパフォーマンス情報へのバッファを返します。
void* SwitchAudioPerformanceFrameBuffer() NN_NOEXCEPT;

// CircularBufferSink から波形データを読み出し、読み出した波形データのサイズを返します。
size_t ReadCircularBufferSink(const void** outBuffer) NN_NOEXCEPT;
