﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdio>
#include <cstring>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>
#include <nn/os.h>

#include <nn/socket.h>

namespace nns {
namespace socket {

class MulticastSend
{
private:
    static const size_t    SendBufferSize;

    nn::socket::SockAddrIn m_SockAddr;
    char                   m_MulitcastGroupAddr[50];
    uint64_t               m_SentTotalBytes;
    int                    m_UdpSendSocket;
    uint16_t               m_MulticastUDPPort;
    char*                  m_pSendData;
    bool                   m_IsInitialized;

public:
    MulticastSend() NN_NOEXCEPT;
    ~MulticastSend() NN_NOEXCEPT;

    int          Initialize(const char* pMulitcastGroupAddr, const uint16_t multicastUDPPort, const char* pNetworkInterface) NN_NOEXCEPT;
    int          Finalize() NN_NOEXCEPT;
    int          SendMessages(const int totalTimeInSeconds) NN_NOEXCEPT;
    uint64_t     GetTotalBytesSent() NN_NOEXCEPT;
};

}}   // Namespace nns / socket
