﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{SettingsLanguage_Main.cpp,PageSampleSettingsLanguage}
 *
 * @brief
 *  nn::settings ライブラリの言語コードの扱い方を示すサンプルプログラム
 */

/**
 * @page PageSampleSettingsLanguage 言語コードの操作
 * @tableofcontents
 *
 * @brief
 * nn::settings ライブラリの言語コードを操作するサンプルプログラムの解説です。
 *
 * @section PageSampleSettingsLanguage_SectionBrief 概要
 * 言語コードの扱い方について説明します。
 *
 * @section PageSampleSettingsLanguage_SectionFileStructure ファイル構成
 * 本サンプルプログラムは
 * @link ../../../Samples/Sources/Applications/SettingsLanguage
 * Samples/Sources/Applications/SettingsLanguage @endlink 以下にあります。
 *
 * @section PageSampleSettingsLanguage_SectionNecessaryEnvironment 必要な環境
 * 特にありません。
 *
 * @section PageSampleSettingsLanguage_SectionHowToOperate 操作方法
 * 特にありません。
 *
 * @section PageSampleSettingsLanguage_SectionPrecaution 注意事項
 * このサンプルはグラフィックの描画を行いません。実行結果はログに出力されます。
 *
 * @section PageSampleSettingsLanguage_SectionHowToExecute 実行手順
 * サンプルプログラムをビルドし、実行してください。
 *
 * @section PageSampleSettingsLanguage_SectionDetail 解説
 * サンプルプログラムの処理の流れは以下の通りです。
 *
 * - 言語コードのインスタンス作成
 * - 言語コードの表示
 * - 言語コードの比較
 * - 言語コードの受け渡し
 */

#include <nn/nn_Log.h>
#include <nn/settings/settings_Language.h>

namespace {

struct UserInfo
{
    nn::settings::LanguageCode languageCode;
};

} // namespace

extern "C" void nnMain()
{
    // Language 列挙体の値から言語コードを作成することができます
    nn::settings::LanguageCode needle =
        nn::settings::LanguageCode::Make(nn::settings::Language_BritishEnglish);

    // 言語コードの内部表現は IETF 言語タグとして利用できます。
    NN_LOG("IETF Language Tag: %s\n", needle.string);

    const int count = nn::settings::GetAvailableLanguageCodeCount();

    nn::settings::LanguageCode* const
        haystack = new nn::settings::LanguageCode[count];

    // 言語コードの取り得る値を列挙します。
    nn::settings::GetAvailableLanguageCodes(haystack, count);

    if (0 < count)
    {
        // 言語コード同士は演算子で直接比較できます。
        NN_LOG("%s %s %s\n",
               haystack[0].string,
               haystack[0] == needle ? "==" : "!=",
               needle.string);

        // Language 列挙体の値とも演算子で直接比較できます。
        NN_LOG("%s %s %s\n",
               haystack[0].string,
               haystack[0] == nn::settings::Language_Japanese ? "==" : "!=",
               nn::settings::LanguageCode::Make(
                   nn::settings::Language_Japanese).string);
    }

    delete[] haystack;

    // 言語設定をやり取りする際は言語コードを使用します。
    UserInfo userInfo = {};
    userInfo.languageCode = needle;

    NN_LOG("User Language: %s\n", userInfo.languageCode.string);
}
