﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>

extern "C" void nnMain()
{
    NN_LOG("Application v0\n");

    static char buffer[128 * 1024];
    auto result = nn::fs::MountRom("rom", buffer, sizeof(buffer));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    nn::fs::FileHandle file;
    result = nn::fs::OpenFile(&file, "rom:/random-128kb.bin", nn::fs::OpenMode_Read);
    NN_LOG("random-128kb.bin: %s\n", !nn::fs::ResultPathNotFound::Includes(result) ? "Found" : "Not Found");
    if (result.IsSuccess())
    {
        nn::fs::CloseFile(file);
    }

    result = nn::fs::OpenFile(&file, "rom:/random-32kb.bin", nn::fs::OpenMode_Read);
    NN_LOG("random-32kb.bin: %s\n", !nn::fs::ResultPathNotFound::Includes(result) ? "Found" : "Not Found");
    if (result.IsSuccess())
    {
        nn::fs::CloseFile(file);
    }
}
