﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/nn_Abort.h>

void SampleNotifierSubMain(nn::os::Event* pTerminateRequestEvent);

namespace {

nn::os::ThreadType g_SampleNotifierSubMainThread;
NN_OS_ALIGNAS_THREAD_STACK char g_SampleNotifierSubMainThreadStack[1024 * 16];

void SampleNotifierSubMainThreadFunction(void* p) NN_NOEXCEPT
{
    SampleNotifierSubMain(reinterpret_cast<nn::os::Event*>(p));
}

}

extern "C" void nnMain()
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(&g_SampleNotifierSubMainThread, SampleNotifierSubMainThreadFunction, nullptr, g_SampleNotifierSubMainThreadStack, sizeof(g_SampleNotifierSubMainThreadStack), nn::os::DefaultThreadPriority));
    nn::os::StartThread(&g_SampleNotifierSubMainThread);

    nn::os::WaitThread(&g_SampleNotifierSubMainThread);
    nn::os::DestroyThread(&g_SampleNotifierSubMainThread);
}
