﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{OsUserExceptionHandler.cpp,PageSampleOsUserExceptionHandler}
 *
 * @brief
 *  ユーザ例外ハンドラ機能のサンプルプログラム
 */

/**
 * @page PageSampleOsUserExceptionHandler UserExceptionHandler
 * @tableofcontents
 *
 * @brief
 *  ユーザ例外ハンドラ機能のサンプルプログラムの解説です。
 *
 * @section PageSampleOsUserExceptionHandler_SectionBrief 概要
 *  ここでは、独自のユーザ例外ハンドラを登録するサンプルプログラムの説明をします。
 *
 *  ユーザ例外ハンドラ機能の使い方については、
 *  @ref nn::os "OS の関数リファレンス" も併せて参照して下さい。
 *
 * @section PageSampleOsUserExceptionHandler_SectionFileStructure ファイル構成
 *  本サンプルプログラムは @link ../../../Samples/Sources/Applications/OsUserExceptionHandler Samples/Sources/Applications/OsUserExceptionHandler @endlink 以下にあります。
 *  本サンプルは Windows 環境では利用できません。Visual Studio 関連ファイルは
 *  開発機環境用のもののみが提供されます。
 *
 * @section PageSampleOsUserExceptionHandler_SectionNecessaryEnvironment 必要な環境
 *  特になし
 *
 * @section PageSampleOsUserExceptionHandler_SectionHowToOperate 操作方法
 *  特になし
 *
 * @section PageSampleOsUserExceptionHandler_SectionPrecaution 注意事項
 *  このデモは画面上に何も表示されません。実行結果はログに出力されます。
 *
 * @section PageSampleOsUserExceptionHandler_SectionHowToExecute 実行手順
 *  サンプルプログラムをビルドし、実行してください。
 *
 * @section PageSampleOsUserExceptionHandler_SectionDetail 解説
 *
 * @subsection PageSampleOsUserExceptionHandler_SectionSampleProgram サンプルプログラム
 *  以下に本サンプルプログラムのソースコードを引用します。
 *
 *  OsUserExceptionHandler.cpp
 *  @includelineno OsUserExceptionHandler.cpp
 *
 * @subsection PageSampleOsUserExceptionHandler_SectionSampleDetail サンプルプログラムの解説
 *  先のサンプルプログラムの全体像は以下の通りです。
 *
 *  - nnMain() にて、ユーザ例外ハンドラを登録する関数を発行
 *  - VSI デバッガ接続時にもユーザ例外ハンドラを動作させるように設定
 *  - NULL 番地に対して書き込みを行ない、データアクセス例外を意図的に発生
 *  - ユーザ例外ハンドラが起動してログを出力
 *
 *  上記サンプルにおける SetOriginalUserExceptionHandler() 関数の本体や、
 *  ユーザ例外ハンドラ本体の実装は、@link OsUserExceptionHandlerSample.cpp Samples/Sources/Applications/OsUserExceptionHandler/OsUserExceptionHandlerSample.cpp @endlink にあります。
 *  このハンドラ関数は自由にカスタマイズしてご使用下さい。
 *
 *  nn::os::EnableUserExceptionHandlerOnDebugging() に true を指定すると、
 *  VSI デバッガ接続時にもユーザ例外ハンドラが動作するようになりますが、
 *  デバッガはユーザ例外ハンドラ実行後に停止します。そのため、デバッガ上から
 *  観測できる pc レジスタ等の値は例外発生時のものではないので注意が必要です。
 *
 *  なお、ユーザ例外ハンドラは NX32 および NX64 ビルド環境でのみ有効です。
 *  このサンプルプログラムの NX64 ビルド時の実行結果を以下に示します。
 *
 *  @verbinclude  OsUserExceptionHandler_OutputExample.txt
 *
 *  このサンプルは Windows 環境では利用できません。
 *
 */

#include <nn/os.h>

extern void SetOriginalUserExceptionHandler() NN_NOEXCEPT;

//-----------------------------------------------------------------------------
//  メイン関数です。
//
extern "C" void nnMain()
{
    // 独自のユーザ例外ハンドラを登録する
    SetOriginalUserExceptionHandler();

    // VSI デバッガ接続時にもユーザ例外ハンドラを動作させる。
    nn::os::EnableUserExceptionHandlerOnDebugging(true);

    // 意図的に例外を発生させる
    *reinterpret_cast<volatile uint32_t*>(NULL) = 0;
}

