﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

 /**
 * @examplesource{NifmNetworkConnectionSimple_Main.cpp,PageSampleNifmNetworkConnectionSimple}
 *
 * @brief
 */

#include "NifmNetworkConnectionSimple.h"

#include <nn/nn_Abort.h>
#include <nn/os/os_Thread.h>

#include <nns/console/console_ConsoleManager.h>

namespace
{
#if defined(NIFM_SAMPLE_WITH_GUI) // プロジェクトファイルで定義
    // 描画用リソース
    nns::console::DefaultConsoleManagerHolder g_ConsoleManagerHolder = NNS_CONSOLE_CONSOLE_MANAGER_HOLDER_INITIALIZER;
#endif
    // アプリケーションスレッド
    NN_ALIGNAS(4096) char g_ThreadStack[4 * nn::os::MemoryPageSize];

} // 無名名前空間終わり

extern "C" void nnMain()
{
    // アプリケーションコンテナの初期化
    Program program;
#if defined(NIFM_SAMPLE_WITH_GUI)
    // 画面描画用リソースの初期化
    auto& manager = g_ConsoleManagerHolder.GetManager();
    manager.Register(&program, 0, 0, manager.Settings.ScreenWidth, manager.Settings.ScreenHeight);
#endif
    // アプリケーションの実行
    nn::os::ThreadType thread;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(&thread, program.ThreadFunction, &program, g_ThreadStack, sizeof(g_ThreadStack), nn::os::DefaultThreadPriority));
    nn::os::SetThreadNamePointer(&thread, "Program");
    nn::os::StartThread(&thread);
#if defined(NIFM_SAMPLE_WITH_GUI)
    while (NN_STATIC_CONDITION(true))
    {
        manager.Update();
        manager.Draw();
    }
#endif
    nn::os::WaitThread(&thread);
}
