﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommonTypes.h>

const nn::hid::NpadIdType NpadIds[] =
{
    nn::hid::NpadId::No1,
    nn::hid::NpadId::No2,
    nn::hid::NpadId::No3,
    nn::hid::NpadId::No4,
    nn::hid::NpadId::Handheld,
};
const int NpadIdCountMax = sizeof(NpadIds) / sizeof(nn::hid::NpadIdType);

/*!
    @brief      ヒューマンインターフェイスデバイス機能が初期化済みかを判定します。
    @return     初期化済みならば true を返します。
*/
bool IsHidControllerInitialized() NN_NOEXCEPT;

/*!
    @brief      ヒューマンインターフェイスデバイス機能を初期化します。
*/
void InitializeHidController() NN_NOEXCEPT;

/*!
    @brief      ヒューマンインターフェイスデバイス機能を終了します。
*/
void FinalizeHidController() NN_NOEXCEPT;

/*!
    @brief      ヒューマンインターフェイスデバイス機能を終了します。
*/
void UpdateHidController() NN_NOEXCEPT;

/*!
    @brief      指定されたデジタルボタンが最後の更新で新たに押下されたか否かを返します。
    @param[in]      id              Npad の指定です。
    @param[in]      buttons         デジタルボタンの指定です。
    @return     指定されたデジタルボタンの何れかが新たに押下されたなら真を返します。
*/
bool HasHidControllerAnyButtonsDown(nn::hid::NpadIdType id, nn::hid::NpadButtonSet buttons) NN_NOEXCEPT;

/*!
    @brief      接続されている Npad の ID リストを返します。
    @param[out]      pOutBuffer      Npad の ID リストを格納するためのバッファです。
    @param[in]       bufferCount     バッファの数です。
    @return     リストに返された Npad の数を返します。
*/
int ListHidControllerConnectedNpadIds(nn::hid::NpadIdType* pOutBuffer, int bufferCount) NN_NOEXCEPT;

/*!
    @brief      指定されたコントローラのプレイヤーランプの点灯パターンを返します。
    @param[in]      id              Npad の指定です。
    @return     指定されたコントローラのプレイヤーランプの点灯パターンを返します。
*/
nn::Bit8 GetHidControllerPlayerLedPattern(nn::hid::NpadIdType id) NN_NOEXCEPT;
