﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include "ConfigSystem.h"

namespace nns { namespace nfp {

    /*!
        @brief      アプリケーションの状態を更新します。
        @param[in,out]  data        アプリケーションで扱うデータです。
     */
    void UpdateState(ApplicationData& data) NN_NOEXCEPT;

    /*!
        @brief      バックグラウンドに遷移させるために、実行中の NFP 処理を中断します。
        @param[in,out]  data        アプリケーションで扱うデータです。
     */
    void Cancel(ApplicationData& data) NN_NOEXCEPT;

    /*!
        @brief      終了させるために、実行中の NFP 処理を終了します。
        @param[in,out]  data        アプリケーションで扱うデータです。
     */
    void Finalize(ApplicationData& data) NN_NOEXCEPT;

}} // end of namespace nns::nfp
