﻿$TryCount        = 100
$SleepSec        = 20
$ScriptDir       = Split-Path -Parent $MyInvocation.MyCommand.Path
$DateTimeString  = Get-Date -Format "yyyyMMdd.HHmm"
$LogFilePrefix   = Resolve-Path "$ScriptDir\.."
$LogFilePrefix  = "$LogFilePrefix\Log-Print50-$DateTimeString"
$NintendoSdkRoot = $env:NINTENDO_SDK_ROOT
$ToolRoot        = "$NintendoSdkRoot\Tools\CommandLineTools"
$RunOnTarget     = "$ToolRoot\RunOnTarget.exe"
$ControlTarget   = "$ToolRoot\ControlTarget.exe"
$Targets         = $Args

function Get-AppPath
{
    $result = ""
    # sdk git ツリー内かどうかを、Samples/NintendoSdkSampleRootMark の有無で判断する
    if (Test-Path "$ScriptDir\..\..\..\..\NintendoSdkSampleRootMark")
    {
        $result = Join-Path (Resolve-Path "$ScriptDir\..\..\..\..\") "Outputs\NX-NXFP2-a64\Applications\testMultipleDevkits_Print50\Develop\testMultipleDevkits_Print50.nspd"
    }
    else
    {
        $result = Join-Path (Resolve-Path "$ScriptDir\..\TargetApp\Print50") "Binaries\NX64\NX_Develop\testMultipleDevkits_Print50.nspd"
    }

    if (!(Test-Path $result)) {
        "[ERROR] Cannot find $result. Please build this."
        exit
    }
    return $result
}
$App = Get-AppPath


function Summarize-Setting
{
    "`nTarget devkits are ..."
    foreach ($target in $Targets) {
        "  $target"
    }

    "`nLog files are ..."
    foreach ($target in $Targets) {
        "  $LogFilePrefix@$target.txt"
    }
    
    "`nTools and app are ..."
    "  (NINTENDO_SDK_ROOT) $env:NINTENDO_SDK_ROOT"
    "  $RunOnTarget"
    "  $ControlTarget"
    "  $App"
}

function Register-Target
{
    "`n### Register-Target"
    "  ControlTarget unregister-all"
    Invoke-Expression "$ControlTarget unregister-all"
    foreach ($target in $Targets) {
        "  ControlTarget register -t $target"
        Invoke-Expression "$ControlTarget register -t $target"
        "  ControlTarget connect -t $target"
        Invoke-Expression "$ControlTarget connect -t $target"
    }
    "  register finish (sleep 10sec)"
    Start-Sleep -s 10
}

function Terminate-AllTarget
{
    "`n### Terminate-AllTarget"
    foreach ($target in $Targets) {
        Start-Job -ScriptBlock {
            param($executer, $name)
            Invoke-Expression "$executer terminate --target $name"
        } -ArgumentList $ControlTarget, $target
    }
    Get-Job | Wait-Job
    Start-Sleep -s 5
}

function Run-Application()
{
    "`n### Run-Application"
    foreach ($target in $Targets) {
        Start-Job -ScriptBlock {
            param($executer, $app, $name, $prefix)
            $logFileName = "$prefix@$name.txt"
            & $executer $app --target $name -- $name 2>&1 | Out-File -filepath $logFileName -Encoding UTF8 -Append -Width 1000
        } -ArgumentList $RunOnTarget, $App, $target, $LogFilePrefix
    }
    Start-Sleep -s $SleepSec
    Get-Job | Stop-Job
}

Summarize-Setting
Register-Target
for ($i = 0; $i -lt $TryCount; $i++) {
    "`n`n------------------ $i ------------------"
    Run-Application
    Terminate-AllTarget
}
