﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

namespace nns { namespace MultipleDevkits { namespace DebugFont {

void Initialize();
void Update();
void Finalize();
nn::gfx::util::DebugFontTextWriter& GetDebugFontWriter();
void PrintSample(nn::gfx::util::DebugFontTextWriter& writer);

}}} // namespace nns::MultipleDevkits::DebugFont


/*
//------------------------------------------------------------------------------
// sample code
//------------------------------------------------------------------------------
extern "C" void nnMain()
{
    nns::MultipleDevkits::DebugFont::Initialize();

    while (true)
    {
        nn::gfx::util::DebugFontTextWriter& writer = nns::MultipleDevkits::DebugFont::GetDebugFontWriter();
        nns::MultipleDevkits::DebugFont::PrintSample(writer);
        nns::MultipleDevkits::DebugFont::Update();
    }

    nns::MultipleDevkits::DebugFont::Finalize();
}
*/
