﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <nn/nfc.h>

namespace nns { namespace nfc { namespace mifare {

    /*!
        @brief      同じタグ ID (UID) かを判定します。
        @param[in]      id1         比較対象の ID です。
        @param[in]      id2         比較対象の ID です。
        @return     同じならば true を返します。
     */
    inline bool IsEqualId(const nn::nfc::TagId& id1, const nn::nfc::TagId& id2) NN_NOEXCEPT
    {
        return (id1.length == id2.length) && (std::memcmp(id1.uid, id2.uid, id2.length) == 0);
    }

}}} // end of namespace nns::nfc::mifare
