﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/os.h>

#include <map>

class HeapTracker
{
public:
    HeapTracker();
    void Track(void *memory, size_t size);
    void Untrack(void *memory);
    void OutputUsage();

    nn::os::Mutex m_mutex;

private:
    struct AllocationInfo
    {
        AllocationInfo(size_t size = 0, size_t id = -1, void *address = NULL, bool inUse = false);

        size_t m_size;
        size_t m_id;
        void *m_address;
        nn::os::Tick m_time;
        bool m_inUse;
    };

    nn::os::Tick m_creationTime;
    size_t m_total;
    size_t m_maxSize;
    size_t m_id;
    size_t m_capacity;
    size_t m_allocations;
    size_t m_memoryBlockSize;
    AllocationInfo *m_infos;
};
