﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <movie/PlayerExtractor.h>
#include <movie/Extractor.h>
#include <movie/Utils.h>

#include <nn/nn_Assert.h>
#include <nn/nn_SdkLog.h>

#include "MseSourceBuffer.h"

#include <deque>
#include <vector>
#include <cinttypes>
#include <algorithm>

namespace movie { namespace sample {

class MseExtractor : public movie::PlayerExtractor {

public:
    MseExtractor() = default;
    ~MseExtractor() {}

    virtual Status SetDataSource(const char* url) override;

    virtual Status SetDataSource(const void* data, int length) override;

    virtual Status CountTracks(int* tracks) const override;

    virtual Status GetTrackFormat(int32_t index, MediaData *format) const override;

    virtual Status GetFileFormat(MediaData *format) const override;

    virtual Status SelectTrack(int32_t index) override;

    virtual Status UnselectTrack(int32_t index) override;

    virtual Status SeekTo(int64_t timeUs) override;

    virtual Status Advance() override;

    virtual Status ReadSampleData(Buffer *buffer) override;

    virtual Status GetSampleTrackIndex(size_t* index) override;

    virtual Status GetSampleTime(int64_t* sampleTimeUs) override;

    virtual movie::Status GetSampleTime(size_t trackIndex, int64_t* sampleTimeUs) override;

    virtual Status GetSampleMeta(MediaData *sampleMeta) override;

    virtual Status GetFragmentIndex(int32_t* index) override;

    virtual Status GetCachedDuration(int64_t* durationUs, bool* eos) const override;

    virtual Status CancelSetDataSource() override;

    virtual bool IsCacheFull(bool *eosReached) override;

    virtual bool IsSeekable() const override;

    virtual Status TerminateNetworkConnection() override;

    void AddSourceBuffer(MseSourceBuffer* sourceBuffer);

private:
    std::vector<MseSourceBuffer*> mSourceBuffers;
};



}}
