﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <movie/Player.h>
#include <movie/BrowserPlayer.h>
#include <vector>
#include <nn/ssl.h>
#include <nns/mm/mm_NvnVideoRenderer.h>

class MediaPlayerObserver : public movie::BrowserPlayerObserver
{
public:
    MediaPlayerObserver();

    ~MediaPlayerObserver();

    /* Initialize MediaPlayerObserver */
    void Initialize(movie::PlayerConfig* config);

    /* Finalize MediaPlayerObserver */
    void Finalize(movie::PlayerConfig* config);

    bool IsPlaybackComplete() { return m_PlayBackDone; }

    void SetPlaybackComplete() { m_PlayBackDone = true; }

    void ResetPlaybackComplete() { m_PlayBackDone = false; }

    virtual void OnError(movie::Status movieStatus);

    virtual void OnStateChange(movie::PlayerState state);

    virtual void OnAudioOutputFrameAvailable(movie::AudioFrameInfo* frameInfo);

    virtual void OnVideoOutputFrameAvailable(movie::VideoFrameInfo* frameInfo);

    /* Called repeatedly after Player::Start() while the movie preloads */
    virtual void OnBufferingUpdate(float startTime, float endTime);

    /*  Called after curl_easy_init() for an HTTP request. Return 0 to proceed */
    virtual int32_t OnCurlInit(CURL *easyRequest, const char* uri);

    /*  Called before curl_easy_perform() for an HTTP request. Return 0 to proceed */
    virtual int32_t OnHttpRequest(CURL *easyRequest, const char* uri);

    /* Called before curl_multi_perform() for an HTTP request. Return 0 to proceed */
    virtual int32_t OnMultiConfig(CURLM *multiRequest, const char* uri);

    /* Called after curl_multi_perform() for an HTTP request. Return 0 to proceed. */
    virtual int32_t OnHttpResponse(CURLM *multiRequest, const char* uri);

    virtual void OnOutputBufferAvailable(int trackNumber, movie::TrackType eTrackType);

    virtual void OnOutputBufferAvailable(int trackNumber, movie::TrackType eTrackType, int64_t presentationTimeUs, int32_t index);

    virtual void OnFormatChanged(movie::TrackType eTrackType);

    virtual void OnVideoFrameDropped(int64_t presentationTimeUs);

    void SetMoviePlayer(movie::BrowserPlayer*  player);

    void GetMoviPlayer(movie::BrowserPlayer** player)  { *player = m_Player; }

    void SetAudioTrackNumber(int32_t audioTrackNumber)  { m_AudioTrackNumber = audioTrackNumber; }

    void GetAudioTrackNumber(int32_t *audioTrackNumber)  { *audioTrackNumber = m_AudioTrackNumber; }

    void SetVideoTrackNumber(int32_t videoTrackNumber)  { m_VideoTrackNumber = videoTrackNumber; }

    void GetVideoTrackNumber(int32_t *videoTrackNumber)  { *videoTrackNumber = m_VideoTrackNumber; }

    void ResizeTextures(int width, int height);

    void DrawVideoNvn(int videoBufferIndex, int cropWidth, int cropheight, int yOffset, int uvOffset, int yStride, int colorSpace);

    NvnVideoRenderer* GetNvnVideoRenderer() { return m_NvnVideoRenderer; }

public:
    struct OutputBufferInfo
    {
        int32_t trackNumber;
        int32_t bufferIndex;
    };
    nn::os::MutexType m_VideoOutputBuffersListMutex;
    std::vector<OutputBufferInfo> m_VideoOutputBuffersList;
    int32_t m_VideoOutputBufferSize {0};
    int32_t m_VideoTrackNumber {0};
    char *m_PcmBuffer {nullptr};
    int32_t m_PcmBufferSize {0};

    static const int m_videoBufferCount = 1;
    NvnBuffer m_videoBufferYUV[m_videoBufferCount];
    movie::Buffer m_videobufferArray[m_videoBufferCount];
    int32_t m_videoBufferIndexArray[m_videoBufferCount];
    int32_t m_PresentationIndex {0};
    nn::os::EventType m_StartPlaybackEvent;
    NvnWindow m_window;
    movie::PlayerConfig m_PlayerConfig;

    int m_CropWidth {0};
    int m_CropHeight {0};
    movie::MediaData m_BufferProperty;

private:
    nn::mem::StandardAllocator m_allocator;
    //void *m_pAllocatorMemory {nullptr};

    NvnVideoRenderer* m_NvnVideoRenderer {nullptr};

    bool m_PlayBackDone {false};
    bool m_NvnInitialized {false};

    movie::BrowserPlayer* m_Player {nullptr};
    int32_t m_AudioTrackNumber {0};

    nn::ssl::Context* m_ctxPtr {nullptr};
};
