﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/nn_Log.h>

namespace {

char g_Utf8StringEnglish[] = {
    '\x57', '\x65', '\x6C', '\x63', '\x6F', '\x6D', '\x65', '\x20',
    '\x74', '\x6F', '\x20', '\x4E', '\x69', '\x6E', '\x74', '\x65',
    '\x6E', '\x64', '\x6F', '\x20', '\x64', '\x65', '\x76', '\x65',
    '\x6C', '\x6F', '\x70', '\x6D', '\x65', '\x6E', '\x74', '\x20',
    '\x65', '\x6E', '\x76', '\x69', '\x72', '\x6F', '\x6E', '\x6D',
    '\x65', '\x6E', '\x74', '\x21', '\0'
}; // Welcome to Nintendo development environment!

char g_Utf8StringChinese[] = {
    '\xE6', '\xAC', '\xA2', '\xE8', '\xBF', '\x8E', '\xE4', '\xBB',
    '\xBB', '\xE5', '\xA4', '\xA9', '\xE5', '\xA0', '\x82', '\xE5',
    '\xBC', '\x80', '\xE5', '\x8F', '\x91', '\xE7', '\x8E', '\xAF',
    '\xE5', '\xA2', '\x83', '\xEF', '\xBC', '\x81', '\0'
}; // 欢迎任天堂开发环境！

char g_Utf8StringJapanese[] = {
    '\xE4', '\xBB', '\xBB', '\xE5', '\xA4', '\xA9', '\xE5', '\xA0',
    '\x82', '\xE9', '\x96', '\x8B', '\xE7', '\x99', '\xBA', '\xE7',
    '\x92', '\xB0', '\xE5', '\xA2', '\x83', '\xE3', '\x81', '\xB8',
    '\xE3', '\x82', '\x88', '\xE3', '\x81', '\x86', '\xE3', '\x81',
    '\x93', '\xE3', '\x81', '\x9D', '\xEF', '\xBC', '\x81', '\0'
}; // 任天堂開発環境へようこそ！

char g_Utf8StringKorean[] = {
    '\xEB', '\x8B', '\x8C', '\xED', '\x85', '\x90', '\xEB', '\x8F',
    '\x84', '\x20', '\xEA', '\xB0', '\x9C', '\xEB', '\xB0', '\x9C',
    '\x20', '\xED', '\x99', '\x98', '\xEA', '\xB2', '\xBD', '\xEC',
    '\x97', '\x90', '\x20', '\xEC', '\x98', '\xA4', '\xEC', '\x8B',
    '\xA0', '\x20', '\xEA', '\xB2', '\x83', '\xEC', '\x9D', '\x84',
    '\x20', '\xED', '\x99', '\x98', '\xEC', '\x98', '\x81', '\xED',
    '\x95', '\xA9', '\xEB', '\x8B', '\x88', '\xEB', '\x8B', '\xA4',
    '\xEF', '\xBC', '\x81', '\0'
}; // 닌텐도 개발 환경에 오신 것을 환영합니다！

char g_Utf8StringRussian[] = {
    '\xD0', '\x94', '\xD0', '\xBE', '\xD0', '\xB1', '\xD1', '\x80',
    '\xD0', '\xBE', '\x20', '\xD0', '\xBF', '\xD0', '\xBE', '\xD0',
    '\xB6', '\xD0', '\xB0', '\xD0', '\xBB', '\xD0', '\xBE', '\xD0',
    '\xB2', '\xD0', '\xB0', '\xD1', '\x82', '\xD1', '\x8C', '\x20',
    '\xD0', '\xBD', '\xD0', '\xB0', '\x20', '\x4E', '\x69', '\x6E',
    '\x74', '\x65', '\x6E', '\x64', '\x6F', '\x20', '\xD1', '\x81',
    '\xD1', '\x80', '\xD0', '\xB5', '\xD0', '\xB4', '\xD1', '\x8B',
    '\x20', '\xD1', '\x80', '\xD0', '\xB0', '\xD0', '\xB7', '\xD1',
    '\x80', '\xD0', '\xB0', '\xD0', '\xB1', '\xD0', '\xBE', '\xD1',
    '\x82', '\xD0', '\xBA', '\xD0', '\xB8', '\x21', '\0'
}; // Добро пожаловать на Nintendo среды разработки!

void PrintMultiLanguages() NN_NOEXCEPT
{
    NN_LOG("Log at %s\n"
        "\tInteger  :%d\n"
        "\tFloat    :%f\n"
        "\tEnglish  :%s\n"
        "\tChinese  :%s\n"
        "\tJapanese :%s\n"
        "\tKorean   :%s\n"
        "\tRussian  :%s\n\n",
        NN_CURRENT_FUNCTION_NAME,
        1234567890,
        12345.67890,
        g_Utf8StringEnglish,
        g_Utf8StringChinese,
        g_Utf8StringJapanese,
        g_Utf8StringKorean,
        g_Utf8StringRussian);

    NN_PUT(g_Utf8StringEnglish, std::strlen(g_Utf8StringEnglish));
    NN_PUT("\n", 1);
    NN_PUT(g_Utf8StringChinese, std::strlen(g_Utf8StringChinese));
    NN_PUT("\n", 1);
    NN_PUT(g_Utf8StringJapanese, std::strlen(g_Utf8StringJapanese));
    NN_PUT("\n", 1);
    NN_PUT(g_Utf8StringKorean, std::strlen(g_Utf8StringKorean));
    NN_PUT("\n", 1);
    NN_PUT(g_Utf8StringRussian, std::strlen(g_Utf8StringRussian));
    NN_PUT("\n\n", 2);
}

void PrintAsciiCharacters() NN_NOEXCEPT
{
    const auto asciiPrintableBegin = ' ';
    const auto asciiPrintableEnd = '~' + 1;
    const auto asciiPrintableCount = (asciiPrintableEnd - asciiPrintableBegin) + 1;
    char asciiPrintableCharacters[asciiPrintableCount + 2];

    for (auto i = 0u; i < asciiPrintableCount; i++)
    {
        asciiPrintableCharacters[i] = static_cast<char>(asciiPrintableBegin + i);
    }

    asciiPrintableCharacters[asciiPrintableCount] = '\n';
    asciiPrintableCharacters[asciiPrintableCount + 1] = '\0';

    NN_LOG("\n");
    NN_LOG(asciiPrintableCharacters);
    NN_PUT(asciiPrintableCharacters, asciiPrintableCount + 1);
    NN_LOG("\n");
}

void PrintXmlText() NN_NOEXCEPT
{
    NN_LOG(
        "<Log>\n"
        "  <PeerName>XAL0000000000</PeerName>\n"
        "  <ProcessId>123</ProcessId>\n"
        "  <ThreadId>12345678901</ThreadId>\n"
        "  <Severity>1</Severity>\n"
        "  <Verbosity>0</Verbosity>\n"
        "  <Timestamp>2017/03/03 00:00:00</Timestamp>\n"
        "  <LineNumber>12</LineNumber>\n"
        "  <FileName>C:\\home\\Siglo\\sdk\\Samples\\Sources\\Applications\\LogManagerClient\\main.cpp</FileName>\n"
        "  <FunctionName>nnMain</FunctionName>\n"
        "  <ModuleName></ModuleName>\n"
        "  <ThreadName>MainThread</ThreadName>\n"
        "  <TextLog>hello, world.\\n</TextLog>\n"
        "</Log>\n\n");
}

void PrintJsonText() NN_NOEXCEPT
{
    NN_LOG(
        "{\n"
        "  \"PeerName\": \"XAL00000000000\",\n"
        "  \"ProcessId\": 123,\n"
        "  \"ThreadId\": 12345678901,\n"
        "  \"Severity\": 1,\n"
        "  \"Verbosity\": 0,\n"
        "  \"Timestamp\": \"2017/03/03 00:00:00\",\n"
        "  \"LineNumber\": 12,\n"
        "  \"FileName\": \"C:\\home\\Siglo\\sdk\\Samples\\Sources\\Applications\\LogManagerClient\\main.cpp\",\n"
        "  \"FunctionName\": \"nnMain\",\n"
        "  \"ModuleName\": \"\",\n"
        "  \"ThreadName\": \"MainThread\",\n"
        "  \"TextLog\": \"hello, world.\\n\"\n"
        "}\n\n");
}

void PrintColorText()
{
    for (int i = 0; i < (1 << 16); i++)
    {
        NN_LOG("%s%s%s%s%s%s%s%s%s\033[3%dm\033[4%dm%04X\033[0m%c",
            ((i >>  0) & 1) != 0 ? "\033[1m" : "",
            ((i >>  1) & 1) != 0 ? "\033[2m" : "",
            ((i >>  2) & 1) != 0 ? "\033[3m" : "",
            ((i >>  3) & 1) != 0 ? "\033[4m" : "",
            ((i >>  4) & 1) != 0 ? "\033[5m" : "",
            ((i >>  5) & 1) != 0 ? "\033[6m" : "",
            ((i >>  6) & 1) != 0 ? "\033[7m" : "",
            ((i >>  7) & 1) != 0 ? "\033[8m" : "",
            ((i >>  8) & 1) != 0 ? "\033[9m" : "",
            ((i >>  9) & 7),
            ((i >> 12) & 7),
            i,
            i % 16 != 15 ? ' ' : '\n');
    }

    for (int i = 0; i < (1 << 16); i++)
    {
        NN_LOG("%s%s%s%s%s%s%s%s%s\033[9%dm\033[10%dm%04X\033[0m%c",
            ((i >>  0) & 1) != 0 ? "\033[1m" : "",
            ((i >>  1) & 1) != 0 ? "\033[2m" : "",
            ((i >>  2) & 1) != 0 ? "\033[3m" : "",
            ((i >>  3) & 1) != 0 ? "\033[4m" : "",
            ((i >>  4) & 1) != 0 ? "\033[5m" : "",
            ((i >>  5) & 1) != 0 ? "\033[6m" : "",
            ((i >>  6) & 1) != 0 ? "\033[7m" : "",
            ((i >>  7) & 1) != 0 ? "\033[8m" : "",
            ((i >>  8) & 1) != 0 ? "\033[9m" : "",
            ((i >>  9) & 7),
            ((i >> 12) & 7),
            i,
            i % 16 != 15 ? ' ' : '\n');
    }
}

} // anonymous

extern "C" void nninitStartup()
{
    PrintMultiLanguages();

    PrintAsciiCharacters();

    PrintXmlText();

    PrintJsonText();
}

extern "C" void nnMain()
{
    PrintMultiLanguages();

    PrintAsciiCharacters();

    PrintXmlText();

    PrintJsonText();

    PrintColorText();
}
